"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlStorageContext = exports.NEW_SERIES_KEY = void 0;
exports.UrlStorageContextProvider = UrlStorageContextProvider;
exports.allSeriesKey = void 0;
exports.convertAllShortSeries = convertAllShortSeries;
exports.reportTypeKey = void 0;
exports.useSeriesStorage = useSeriesStorage;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _exploratory_view_url = require("../configurations/exploratory_view_url");
var _telemetry = require("../utils/telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/hooks/use_series_storage.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UrlStorageContext = exports.UrlStorageContext = /*#__PURE__*/(0, _react.createContext)({});
function convertAllShortSeries(allShortSeries) {
  return (allShortSeries !== null && allShortSeries !== void 0 ? allShortSeries : []).map(shortSeries => convertFromShortUrl(shortSeries));
}
const allSeriesKey = exports.allSeriesKey = 'sr';
const reportTypeKey = exports.reportTypeKey = 'reportType';
function UrlStorageContextProvider({
  children,
  storage
}) {
  const [allSeries, setAllSeries] = (0, _react.useState)(() => {
    var _storage$get;
    return convertAllShortSeries((_storage$get = storage.get(allSeriesKey)) !== null && _storage$get !== void 0 ? _storage$get : []);
  });
  const [lastRefresh, setLastRefresh] = (0, _react.useState)(() => Date.now());
  const [chartTimeRangeContext, setChartTimeRangeContext] = (0, _react.useState)();
  const [reportType, setReportType] = (0, _react.useState)(() => {
    var _get;
    return (_get = storage.get(reportTypeKey)) !== null && _get !== void 0 ? _get : '';
  });
  const [firstSeries, setFirstSeries] = (0, _react.useState)();
  const trackEvent = (0, _public.useUiTracker)();
  (0, _react.useEffect)(() => {
    const firstSeriesT = allSeries === null || allSeries === void 0 ? void 0 : allSeries[0];
    setFirstSeries(firstSeriesT);
  }, [allSeries, storage]);
  const setSeries = (0, _react.useCallback)((seriesIndex, newValue) => {
    setAllSeries(prevAllSeries => {
      const seriesWithCurrentBreakdown = prevAllSeries.findIndex(series => series.breakdown);
      const newStateRest = prevAllSeries.map((series, index) => {
        if (index === seriesIndex) {
          return {
            ...newValue,
            breakdown: seriesWithCurrentBreakdown === seriesIndex || seriesWithCurrentBreakdown === -1 ? newValue.breakdown : undefined
          };
        }
        return series;
      });
      if (prevAllSeries.length === seriesIndex) {
        return [...newStateRest, newValue];
      }
      return [...newStateRest];
    });
  }, []);
  const removeSeries = (0, _react.useCallback)(seriesIndex => {
    setAllSeries(prevAllSeries => prevAllSeries.filter((seriesT, index) => index !== seriesIndex));
  }, []);
  const getSeries = (0, _react.useCallback)(seriesIndex => {
    return allSeries[seriesIndex];
  }, [allSeries]);
  const applyChanges = (0, _react.useCallback)(onApply => {
    const allShortSeries = allSeries.map(series => (0, _exploratory_view_url.convertToShortUrl)(series));
    storage.set(reportTypeKey, reportType);
    storage.set(allSeriesKey, allShortSeries);
    setLastRefresh(Date.now());
    (0, _telemetry.trackTelemetryOnApply)(trackEvent, allSeries, reportType);
    if (onApply) {
      onApply();
    }
  }, [allSeries, storage, trackEvent, reportType]);
  const value = {
    applyChanges,
    storage,
    getSeries,
    setSeries,
    removeSeries,
    allSeries,
    lastRefresh,
    setLastRefresh,
    setReportType,
    reportType,
    chartTimeRangeContext,
    setChartTimeRangeContext,
    firstSeries: firstSeries
  };
  return /*#__PURE__*/_react.default.createElement(UrlStorageContext.Provider, {
    value: value,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 10
    }
  }, children);
}
function useSeriesStorage() {
  return (0, _react.useContext)(UrlStorageContext);
}
function convertFromShortUrl(newValue) {
  const {
    dt,
    op,
    st,
    bd,
    ft,
    time,
    rdf,
    mt,
    h,
    n,
    c,
    spa,
    ...restSeries
  } = newValue;
  return {
    operationType: op,
    seriesType: st,
    breakdown: bd,
    filters: ft,
    time: time,
    reportDefinitions: rdf,
    dataType: dt,
    selectedMetricField: mt,
    hidden: h,
    name: n,
    color: c,
    showPercentileAnnotations: spa,
    ...restSeries
  };
}
const NEW_SERIES_KEY = exports.NEW_SERIES_KEY = 'new-series';