"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlVariablesService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Service to manage ESQL variables for controls
 * The service allows adding, retrieving and clearing variables
 * and enables/disables the creation of control suggestions based on variables.
 */

class EsqlVariablesService {
  constructor() {
    (0, _defineProperty2.default)(this, "esqlVariables", []);
    (0, _defineProperty2.default)(this, "isCreateControlSuggestionEnabled", false);
  }
  enableCreateControlSuggestion() {
    this.isCreateControlSuggestionEnabled = true;
  }
  disableCreateControlSuggestion() {
    this.isCreateControlSuggestionEnabled = false;
  }
  addVariable(variable) {
    const variables = [...this.esqlVariables];
    const variableExists = variables.find(v => v.key === variable.key);
    if (variableExists) {
      return;
    }
    variables.push({
      ...variable,
      value: Number.isNaN(Number(variable.value)) ? variable.value : Number(variable.value)
    });
    this.esqlVariables = variables;
  }
  clearVariables() {
    this.esqlVariables = [];
  }
}
exports.EsqlVariablesService = EsqlVariablesService;