"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateESQLControlAction = void 0;
exports.isActionCompatible = isActionCompatible;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ui-actions-plugin/public");
var _rxjs = require("rxjs");
var _esqlTypes = require("@kbn/esql-types");
var _esqlUtils = require("@kbn/esql-utils");
var _discoverUtils = require("@kbn/discover-utils");
var _presentationUtil = require("@kbn/presentation-util");
var _esqlEditor = require("@kbn/esql-editor");
var _constants = require("../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function isESQLVariableType(value) {
  return Object.values(_esqlTypes.ESQLVariableType).includes(value);
}
function isActionCompatible(core, variableType) {
  return core.uiSettings.get(_esqlUtils.ENABLE_ESQL) && isESQLVariableType(variableType);
}
class CreateESQLControlAction {
  constructor(core, search, timefilter) {
    (0, _defineProperty2.default)(this, "type", _constants.ACTION_CREATE_ESQL_CONTROL);
    (0, _defineProperty2.default)(this, "id", _constants.ACTION_CREATE_ESQL_CONTROL);
    (0, _defineProperty2.default)(this, "order", 50);
    this.core = core;
    this.search = search;
    this.timefilter = timefilter;
  }
  getDisplayName() {
    return _i18n.i18n.translate('esql.createESQLControlLabel', {
      defaultMessage: 'Creates an ES|QL control'
    });
  }
  getIconType() {
    return 'pencil';
  }
  async isCompatible({
    variableType
  }) {
    return isActionCompatible(this.core, variableType);
  }
  async execute({
    queryString,
    variableType,
    esqlVariables,
    onSaveControl,
    onCancelControl,
    cursorPosition,
    initialState,
    parentApi,
    triggerSource
  }) {
    var _this$core$applicatio;
    if (!isActionCompatible(this.core, variableType)) {
      throw new _public.IncompatibleActionError();
    }
    const currentApp = await (0, _rxjs.firstValueFrom)((_this$core$applicatio = this.core.application.currentAppId$) !== null && _this$core$applicatio !== void 0 ? _this$core$applicatio : (0, _rxjs.of)(undefined));
    // Close all existing flyouts before opening the control flyout
    try {
      if (currentApp === 'discover') {
        (0, _discoverUtils.dismissAllFlyoutsExceptFor)(_discoverUtils.DiscoverFlyouts.esqlControls);
      }
    } catch (error) {
      // Flyouts don't exist or couldn't be closed, continue with opening the new flyout
    }
    const telemetryService = new _esqlEditor.ESQLEditorTelemetryService(this.core.analytics);
    const onClose = flyoutRef => {
      onCancelControl === null || onCancelControl === void 0 ? void 0 : onCancelControl();
      flyoutRef.close();
      telemetryService.trackEsqlControlConfigCancelled(variableType, _esqlTypes.TelemetryControlCancelledReason.CLOSE_BUTTON);
    };
    (0, _presentationUtil.openLazyFlyout)({
      core: this.core,
      parentApi,
      loadContent: async ({
        closeFlyout,
        ariaLabelledBy
      }) => {
        const {
          loadESQLControlFlyout
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./esql_control_helpers')));
        return await loadESQLControlFlyout({
          queryString,
          core: this.core,
          search: this.search,
          timefilter: this.timefilter,
          variableType,
          esqlVariables,
          ariaLabelledBy,
          onSaveControl,
          onCancelControl,
          cursorPosition,
          initialState,
          closeFlyout,
          currentApp,
          triggerSource,
          telemetryService
        });
      },
      flyoutProps: {
        'data-test-subj': 'create_esql_control_flyout',
        isResizable: true,
        maxWidth: 800,
        triggerId: 'dashboard-controls-menu-button',
        // When queryString is present (i.e. flyout opened from the ES|QL editor),
        // use the local onClose as the onClose handler to ensure proper nested flyout closing behavior.
        // In other scenarios (opened directly from the dashboard), we keep the default close behavior.
        ...(queryString && {
          onClose
        })
      }
    });
  }
}
exports.CreateESQLControlAction = CreateESQLControlAction;