"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFromCommandHelper = getFromCommandHelper;
exports.getPolicyHelper = getPolicyHelper;
exports.getSourcesHelper = getSourcesHelper;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getPolicyHelper(resourceRetriever) {
  const getPolicies = async () => {
    var _resourceRetriever$ge;
    return (await (resourceRetriever === null || resourceRetriever === void 0 ? void 0 : (_resourceRetriever$ge = resourceRetriever.getPolicies) === null || _resourceRetriever$ge === void 0 ? void 0 : _resourceRetriever$ge.call(resourceRetriever))) || [];
  };
  return {
    getPolicies: async () => {
      const policies = await getPolicies();
      return policies;
    },
    getPolicyMetadata: async policyName => {
      const policies = await getPolicies();
      return policies.find(({
        name
      }) => name === policyName);
    }
  };
}
function getSourcesHelper(resourceRetriever) {
  return async () => {
    var _resourceRetriever$ge2;
    return (await (resourceRetriever === null || resourceRetriever === void 0 ? void 0 : (_resourceRetriever$ge2 = resourceRetriever.getSources) === null || _resourceRetriever$ge2 === void 0 ? void 0 : _resourceRetriever$ge2.call(resourceRetriever))) || [];
  };
}
async function getFromCommandHelper(resourceRetriever) {
  const getSources = getSourcesHelper(resourceRetriever);
  const sources = await (getSources === null || getSources === void 0 ? void 0 : getSources());
  const visibleSources = sources.filter(source => !source.hidden) || [];
  if (visibleSources.find(source => source.name.startsWith('logs'))) {
    return 'FROM logs*';
  }
  if (visibleSources.length > 0) {
    return `FROM ${visibleSources[0].name}`;
  }
  return '';
}