"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.append = append;
var _esqlAst = require("@kbn/esql-ast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function append({
  command,
  params
}) {
  return source => {
    const commandAst = _esqlAst.synth.cmd(command);
    return {
      root: source.root,
      commands: source.commands.concat(commandAst),
      params: params ? source.params.concat(Array.isArray(params) ? params : [params]) : source.params
    };
  };
}