"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dispatchOperators = dispatchOperators;
var _is = require("../../../../../ast/is");
var _handlers = require("./handlers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const handlers = {
  in: _handlers.handleListOperator,
  'not in': _handlers.handleListOperator,
  like: _handlers.handleStringListOperator,
  rlike: _handlers.handleStringListOperator,
  'not like': _handlers.handleStringListOperator,
  'not rlike': _handlers.handleStringListOperator,
  'is null': _handlers.handleNullCheckOperator,
  'is not null': _handlers.handleNullCheckOperator
};
async function dispatchOperators(ctx) {
  const {
    expressionRoot
  } = ctx;
  if (!expressionRoot || !(0, _is.isFunctionExpression)(expressionRoot)) {
    return null;
  }
  const {
    name
  } = expressionRoot;
  const handler = handlers[name.toLocaleLowerCase()];
  if (!handler) {
    return null;
  }
  return handler(ctx);
}