"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autocomplete = autocomplete;
var _is = require("../../../ast/is");
var _location = require("../../../ast/location");
var _complete_items = require("../../complete_items");
var _utils = require("../../../definitions/utils");
var _expressions = require("../../../definitions/utils/expressions");
var _types = require("../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function autocomplete(query, command, callbacks, context, cursorPosition = query.length) {
  if (!(callbacks !== null && callbacks !== void 0 && callbacks.getByType)) {
    return [];
  }
  const innerText = query.substring(0, cursorPosition);
  const expressionRoot = command.args[0];
  const suggestions = await (0, _utils.suggestForExpression)({
    query,
    expressionRoot,
    command,
    cursorPosition,
    location: _types.Location.WHERE,
    context,
    callbacks,
    options: {
      preferredExpressionType: 'boolean'
    }
  });
  const insideFunction = expressionRoot && (0, _is.isFunctionExpression)(expressionRoot) && (0, _location.within)(cursorPosition, expressionRoot);
  const expressionType = (0, _expressions.getExpressionType)(expressionRoot, context === null || context === void 0 ? void 0 : context.columns);
  if (
  // Complete boolean expression
  expressionType === 'boolean' && (0, _expressions.isExpressionComplete)(expressionType, innerText) &&
  // Don't suggest pipe if we're inside a function
  !insideFunction) {
    suggestions.push(_complete_items.pipeCompleteItem);
  }
  return suggestions;
}