"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renameCommand = void 0;
var _i18n = require("@kbn/i18n");
var _autocomplete = require("./autocomplete");
var _columns_after = require("./columns_after");
var _validate = require("./validate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const renameCommandMethods = {
  autocomplete: _autocomplete.autocomplete,
  columnsAfter: _columns_after.columnsAfter,
  validate: _validate.validate
};
const renameCommand = exports.renameCommand = {
  name: 'rename',
  methods: renameCommandMethods,
  metadata: {
    description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.renameDoc', {
      defaultMessage: 'Renames an old column to a new one'
    }),
    declaration: 'RENAME old_name1 AS new_name1[, ..., old_nameN AS new_nameN]',
    examples: ['… | RENAME old AS new', '… | RENAME old AS new, a AS b']
  }
};