"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validUser = exports.unknownMappingErrors = exports.partialUser = exports.nameIsTextMapping = exports.invalidUser3 = exports.invalidUser2 = exports.invalidUser1 = exports.invalidMapping = exports.ageIsIntegerMapping = void 0;
var mappings = _interopRequireWildcard(require("../mappings"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Test create a MappingsDefinition and verify its type
const userMapping = {
  properties: {
    name: mappings.text(),
    age: mappings.integer(),
    email: mappings.keyword(),
    isActive: mappings.boolean(),
    createdAt: mappings.date()
  }
};

// Test DocumentOf should infer the correct document type from the mapping

// Verify successful cases - these should compile without errors
const validUser = exports.validUser = {
  name: 'John Doe',
  age: 30,
  email: 'john@example.com',
  isActive: true,
  createdAt: '2024-01-01T00:00:00Z'
};

// Partial document should also work
const partialUser = exports.partialUser = {
  name: 'Jane Doe',
  age: 25
};

// Test type errors - these should cause TypeScript errors
// ERROR: wrong type for name (should be string)
const invalidUser1 = exports.invalidUser1 = {
  // @ts-expect-error - name must be a string
  name: 123,
  age: 30
};

// ERROR: wrong type for age (should be number)
const invalidUser2 = exports.invalidUser2 = {
  name: 'John',
  // @ts-expect-error - age must be a number
  age: 'thirty'
};

// ERROR: wrong type for isActive (should be boolean)
const invalidUser3 = exports.invalidUser3 = {
  name: 'John',
  // @ts-expect-error - isActive must be a boolean
  isActive: 'yes'
};

// Test that MappingsDefinition enforces correct property types
// ERROR: invalid mapping type
const invalidMapping = exports.invalidMapping = {
  properties: {
    // @ts-expect-error - not_mapped is not defined in the mapping
    not_mapped: {
      type: 'invalid_type'
    }
  }
};

// Test objects
const objectMapping = {
  properties: {
    nestedObj: mappings.object({
      properties: {
        name: mappings.text(),
        age: mappings.integer()
      }
    })
  }
};
const nameIsTextMapping = exports.nameIsTextMapping = objectMapping.properties.nestedObj.properties.name;
const ageIsIntegerMapping = exports.ageIsIntegerMapping = objectMapping.properties.nestedObj.properties.age;

// @ts-expect-error - Unknown object nested mapping properties are not allowed
const unknownMappingErrors = exports.unknownMappingErrors = objectMapping.properties.nestedObj.properties.unknown;