"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateSearchApplication = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _api = require("../../../../../common/types/api");
var _constants = require("../../../shared/constants");
var _doc_links = require("../../../shared/doc_links");
var _handle_api_errors = require("../../../shared/flash_messages/handle_api_errors");
var _query_params = require("../../../shared/query_params");
var _indices_select_combobox = require("./components/indices_select_combobox");
var _create_search_application_logic = require("./create_search_application_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/applications/components/search_applications/create_search_application_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CreateSearchApplication = ({
  onClose
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    createSearchApplication,
    setName,
    setSelectedIndices
  } = (0, _kea.useActions)(_create_search_application_logic.CreateSearchApplicationLogic);
  const {
    createDisabled,
    createSearchApplicationError,
    createSearchApplicationStatus,
    searchApplicationName,
    searchApplicationNameStatus,
    formDisabled,
    indicesStatus,
    selectedIndices
  } = (0, _kea.useValues)(_create_search_application_logic.CreateSearchApplicationLogic);
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    ...params
  } = (0, _query_params.parseQueryParams)(search);
  const indexName = params[_constants.ESINDEX_QUERY_PARAMETER];
  const onIndicesChange = selectedOptions => {
    setSelectedIndices(selectedOptions.map(option => option.label));
  };
  (0, _react.useEffect)(() => {
    if (indexName && typeof indexName === 'string') setSelectedIndices([indexName]);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    size: "m",
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.createSearchApplication.headerTitle', {
    defaultMessage: 'Create a search application'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.createSearchApplication.headerSubTitle",
    defaultMessage: "Explore our {docsLink} to learn more!",
    values: {
      docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _doc_links.docLinks.searchApplications,
        target: "_blank",
        "data-telemetry-id": "entSearchApplications-createSearchApplication-docsLink",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 19
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.createSearchApplication.header.docsLink', {
        defaultMessage: 'Search applications documentation'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 13
    }
  }))), createSearchApplicationStatus === _api.Status.ERROR && createSearchApplicationError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "danger",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.createSearchApplication.header.createError.title', {
      defaultMessage: 'Error creating search application'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  }, (0, _handle_api_errors.getErrorsFromHttpResponse)(createSearchApplicationError).map((errMessage, i) => /*#__PURE__*/_react.default.createElement("p", {
    id: `createErrorMsg.${i}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 17
    }
  }, errMessage))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.createSearchApplication.featureCallOut.title', {
      defaultMessage: 'Beta feature'
    }),
    color: "warning",
    iconType: "beaker",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.createSearchApplication.featureCallOut.description",
    defaultMessage: "This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      children: /*#__PURE__*/_react.default.createElement(_indices_select_combobox.IndicesSelectComboBox, {
        fullWidth: true,
        isDisabled: formDisabled,
        onChange: onIndicesChange,
        selectedOptions: selectedIndices.map(index => (0, _indices_select_combobox.indexToOption)(index)),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 160,
          columnNumber: 21
        }
      }),
      status: indicesStatus,
      title: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.createSearchApplication.selectIndices.title', {
        defaultMessage: 'Select indices'
      })
    }, {
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        fullWidth: true,
        disabled: formDisabled,
        placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.createSearchApplication.searchApplicationName.placeholder', {
          defaultMessage: 'Search application name'
        }),
        value: searchApplicationName,
        onChange: e => setName(e.target.value),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 175,
          columnNumber: 21
        }
      }),
      status: searchApplicationNameStatus,
      title: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.createSearchApplication.searchApplicationName.title', {
        defaultMessage: 'Name your search application'
      })
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    disabled: formDisabled,
    "data-telemetry-id": "entSearchApplications-createSearchApplication-cancel",
    onClick: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 13
    }
  }, _constants.CANCEL_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isDisabled: createDisabled || formDisabled,
    "data-telemetry-id": "entSearchApplications-createSearchApplication-submit",
    fill: true,
    iconType: "plusInCircle",
    onClick: () => createSearchApplication(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.createSearchApplication.submit', {
    defaultMessage: 'Create'
  }))))));
};
exports.CreateSearchApplication = CreateSearchApplication;