"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsCollectionView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _routes = require("../../routes");
var _add_analytics_collection = require("../add_analytics_collections/add_analytics_collection");
var _page_template = require("../layout/page_template");
var _analytics_collection_data_view_logic = require("./analytics_collection_data_view_logic");
var _analytics_collection_explorer = require("./analytics_collection_explorer/analytics_collection_explorer");
var _analytics_collection_integrate_view = require("./analytics_collection_integrate/analytics_collection_integrate_view");
var _analytics_collection_overview = require("./analytics_collection_overview/analytics_collection_overview");
var _analytics_collection_toolbar_logic = require("./analytics_collection_toolbar/analytics_collection_toolbar_logic");
var _fetch_analytics_collection_logic = require("./fetch_analytics_collection_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/analytics/components/analytics_collection_view/analytics_collection_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnalyticsCollectionView = () => {
  (0, _kea.useMountedLogic)(_analytics_collection_toolbar_logic.AnalyticsCollectionToolbarLogic);
  (0, _kea.useMountedLogic)(_analytics_collection_data_view_logic.AnalyticsCollectionDataViewLogic);
  const {
    fetchAnalyticsCollection
  } = (0, _kea.useActions)(_fetch_analytics_collection_logic.FetchAnalyticsCollectionLogic);
  const {
    analyticsCollection,
    isLoading
  } = (0, _kea.useValues)(_fetch_analytics_collection_logic.FetchAnalyticsCollectionLogic);
  const {
    name
  } = (0, _reactRouterDom.useParams)();
  (0, _react.useEffect)(() => {
    fetchAnalyticsCollection(name);
  }, []);
  if (analyticsCollection) {
    return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      exact: true,
      path: _routes.COLLECTION_OVERVIEW_PATH,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_analytics_collection_overview.AnalyticsCollectionOverview, {
      analyticsCollection: analyticsCollection,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      exact: true,
      path: _routes.COLLECTION_INTEGRATE_PATH,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_analytics_collection_integrate_view.AnalyticsCollectionIntegrateView, {
      analyticsCollection: analyticsCollection,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      exact: true,
      path: _routes.COLLECTION_EXPLORER_PATH,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_analytics_collection_explorer.AnalyticsCollectionExplorer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 11
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchAnalyticsPageTemplate, {
    pageChrome: [],
    restrictWidth: true,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "search",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.collectionNotFoundState.headingTitle', {
      defaultMessage: 'You may have deleted this analytics collection'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.collectionNotFoundState.subHeading', {
      defaultMessage: 'An analytics collection provides a place to store the analytics events for any given search application you are building. Create a new collection to get started.'
    })),
    actions: [/*#__PURE__*/_react.default.createElement(_add_analytics_collection.AddAnalyticsCollection, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 19
      }
    })],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }));
};
exports.AnalyticsCollectionView = AnalyticsCollectionView;