"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsCollectionNoEventsCalloutLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../../common/types/api");
var _check_analytics_events_exist_api_logic = require("../../../api/check_analytics_events/check_analytics_events_exist_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalyticsCollectionNoEventsCalloutLogic = exports.AnalyticsCollectionNoEventsCalloutLogic = (0, _kea.kea)({
  actions: {
    analyticsEventsExist: indexName => ({
      indexName
    })
  },
  connect: {
    actions: [_check_analytics_events_exist_api_logic.AnalyticsEventsExistAPILogic, ['makeRequest', 'apiSuccess', 'apiError']],
    values: [_check_analytics_events_exist_api_logic.AnalyticsEventsExistAPILogic, ['status', 'data']]
  },
  listeners: ({
    actions
  }) => ({
    analyticsEventsExist: ({
      indexName
    }) => {
      actions.makeRequest({
        indexName
      });
    }
  }),
  path: ['enterprise_search', 'analytics', 'collection', 'events_exist'],
  selectors: ({
    selectors
  }) => ({
    hasEvents: [() => [selectors.data], data => (data === null || data === void 0 ? void 0 : data.exists) === true],
    isLoading: [() => [selectors.status], status => status === _api.Status.LOADING]
  })
});