"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AGENT_NODE_TAG = void 0;
exports.runAgent = runAgent;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AGENT_NODE_TAG = exports.AGENT_NODE_TAG = 'agent_run';

/**
 * Node to run the agent
 *
 * @param logger - The scoped logger
 * @param state - The current state of the graph
 * @param config - Any configuration that may've been supplied
 * @param model - The LLM
 */
async function runAgent({
  logger,
  state,
  model,
  config
}) {
  logger.debug(() => `${_constants.NodeType.AGENT}: Node state:\n${JSON.stringify(state, null, 2)}`);
  const modifiedMessages = state.messages.map(message => {
    if ('content' in message && typeof message.content === 'string' && (message.content[message.content.length - 1] === '}' || message.content[message.content.length - 1] === ']')) {
      /* The Gemini models throw an error if the content can be parsed as JSON.
      A hack to avoid this is to append a period to the end of the message. This map
      should be removed when the root cause of that issue is fixed.
      */
      const newContent = `${message.content}.`;
      message.content = newContent;
      message.lc_kwargs.content = newContent;
    }
    return message;
  });
  const result = await model.withConfig({
    tags: [AGENT_NODE_TAG],
    ...config
  }).invoke(modifiedMessages);
  return {
    messages: [result],
    lastNode: _constants.NodeType.AGENT
  };
}