"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PopoverReference = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _content_reference_button = require("./content_reference_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/elastic_assistant/public/src/components/get_comments/content_reference/components/popover_reference.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PopoverReference = ({
  contentReferenceCount,
  children,
  ...rest
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setIsPopoverOpen(prev => !prev), []);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const openPopover = (0, _react.useCallback)(() => setIsPopoverOpen(true), []);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_content_reference_button.ContentReferenceButton, {
    onClick: togglePopover,
    onMouseEnter: openPopover,
    contentReferenceCount: contentReferenceCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }), [contentReferenceCount, openPopover, togglePopover]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, (0, _extends2.default)({
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    onMouseLeave: closePopover,
    anchorPosition: "upCenter",
    className: (0, _css.css)`
        vertical-align: baseline;
      `
  }, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }), children);
};
exports.PopoverReference = PopoverReference;