"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getILMExplainRoute = void 0;
var _constants = require("../../common/constants");
var _lib = require("../lib");
var _build_response = require("../lib/build_response");
var _common = require("../schemas/common");
var _get_ilm_explain = require("../schemas/get_ilm_explain");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getILMExplainRoute = (router, logger) => {
  router.versioned.get({
    path: _constants.GET_ILM_EXPLAIN,
    access: 'internal',
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    }
  }).addVersion({
    version: _constants.INTERNAL_API_VERSION,
    validate: {
      request: {
        params: (0, _common.buildRouteValidation)(_get_ilm_explain.GetILMExplainParams)
      }
    }
  }, async (context, request, response) => {
    const resp = (0, _build_response.buildResponse)(response);
    try {
      const {
        client
      } = (await context.core).elasticsearch;
      const decodedIndexName = decodeURIComponent(request.params.pattern);
      const ilmExplain = await (0, _lib.fetchILMExplain)(client, decodedIndexName);
      return response.ok({
        body: ilmExplain.indices
      });
    } catch (err) {
      var _err$message, _err$statusCode;
      logger.error(JSON.stringify(err));
      return resp.error({
        body: (_err$message = err.message) !== null && _err$message !== void 0 ? _err$message : _translations.API_DEFAULT_ERROR_MESSAGE,
        statusCode: (_err$statusCode = err.statusCode) !== null && _err$statusCode !== void 0 ? _err$statusCode : 500
      });
    }
  });
};
exports.getILMExplainRoute = getILMExplainRoute;