"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildServices = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var _lodash = require("lodash");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Location state of internal Discover history instance
 */

const buildServices = ({
  core,
  plugins,
  context,
  locator,
  contextLocator,
  singleDocLocator,
  history,
  scopedHistory,
  urlTracker,
  profilesManager,
  ebtManager,
  setHeaderActionMenu = _lodash.noop
}) => {
  var _plugins$savedObjects;
  const {
    usageCollection
  } = plugins;
  const storage = new _public.Storage(localStorage);
  return {
    aiops: plugins.aiops,
    application: core.application,
    addBasePath: core.http.basePath.prepend,
    analytics: core.analytics,
    capabilities: core.application.capabilities,
    contentManagement: plugins.contentManagement,
    chrome: core.chrome,
    core,
    data: plugins.data,
    dataVisualizer: plugins.dataVisualizer,
    discoverShared: plugins.discoverShared,
    discoverFeatureFlags: {
      getTabsEnabled: () => core.featureFlags.getBooleanValue(_constants.TABS_ENABLED_FEATURE_FLAG_KEY, true)
    },
    docLinks: core.docLinks,
    embeddable: plugins.embeddable,
    i18n: core.i18n,
    theme: core.theme,
    userProfile: core.userProfile,
    fieldFormats: plugins.fieldFormats,
    filterManager: plugins.data.query.filterManager,
    history,
    getScopedHistory: () => scopedHistory,
    setHeaderActionMenu,
    dataViews: plugins.data.dataViews,
    inspector: plugins.inspector,
    metadata: {
      branch: context.env.packageInfo.branch
    },
    navigation: plugins.navigation,
    share: plugins.share,
    urlForwarding: plugins.urlForwarding,
    urlTracker,
    timefilter: plugins.data.query.timefilter.timefilter,
    toastNotifications: core.notifications.toasts,
    notifications: core.notifications,
    uiSettings: core.uiSettings,
    settings: core.settings,
    storage,
    trackUiMetric: usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.reportUiCounter.bind(usageCollection, 'discover'),
    dataViewFieldEditor: plugins.dataViewFieldEditor,
    http: core.http,
    spaces: plugins.spaces,
    dataViewEditor: plugins.dataViewEditor,
    triggersActionsUi: plugins.triggersActionsUi,
    locator,
    contextLocator,
    singleDocLocator,
    expressions: plugins.expressions,
    charts: plugins.charts,
    savedObjectsTagging: (_plugins$savedObjects = plugins.savedObjectsTaggingOss) === null || _plugins$savedObjects === void 0 ? void 0 : _plugins$savedObjects.getTaggingApi(),
    savedObjectsManagement: plugins.savedObjectsManagement,
    savedSearch: plugins.savedSearch,
    unifiedSearch: plugins.unifiedSearch,
    lens: plugins.lens,
    uiActions: plugins.uiActions,
    contentClient: plugins.contentManagement.client,
    noDataPage: plugins.noDataPage,
    observabilityAIAssistant: plugins.observabilityAIAssistant,
    profilesManager,
    ebtManager,
    fieldsMetadata: plugins.fieldsMetadata,
    logsDataAccess: plugins.logsDataAccess,
    embeddableEnhanced: plugins.embeddableEnhanced
  };
};
exports.buildServices = buildServices;