"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInitialAppState = getInitialAppState;
var _esQuery = require("@kbn/es-query");
var _data_sources = require("../../../../../common/data_sources");
var _state_helpers = require("../../../../utils/state_helpers");
var _get_state_defaults = require("./get_state_defaults");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getInitialAppState({
  initialUrlState,
  savedSearch,
  overrideDataView,
  services
}) {
  const defaultAppState = (0, _get_state_defaults.getStateDefaults)({
    savedSearch,
    overrideDataView,
    services
  });
  const mergedState = {
    ...defaultAppState,
    ...initialUrlState
  };

  // https://github.com/elastic/kibana/issues/122555
  if (typeof mergedState.hideChart !== 'boolean') {
    mergedState.hideChart = undefined;
  }

  // Don't allow URL state to overwrite the data source if there's an ES|QL query
  if ((0, _esQuery.isOfAggregateQueryType)(mergedState.query) && !(0, _data_sources.isEsqlSource)(mergedState.dataSource)) {
    mergedState.dataSource = (0, _data_sources.createEsqlDataSource)();
  }
  return (0, _state_helpers.handleSourceColumnState)(mergedState, services.uiSettings);
}