"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAdHocDataViews = void 0;
var _react = require("react");
var _analytics = require("@kbn/analytics");
var _discover_state_provider = require("../state_management/discover_state_provider");
var _constants = require("../../../constants");
var _use_filters_validation = require("./use_filters_validation");
var _use_is_esql_mode = require("./use_is_esql_mode");
var _redux = require("../state_management/redux");
var _use_discover_services = require("../../../hooks/use_discover_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useAdHocDataViews = () => {
  const dataView = (0, _redux.useCurrentDataView)();
  const savedSearch = (0, _discover_state_provider.useSavedSearch)();
  const isEsqlMode = (0, _use_is_esql_mode.useIsEsqlMode)();
  const {
    filterManager,
    toastNotifications,
    trackUiMetric
  } = (0, _use_discover_services.useDiscoverServices)();
  (0, _react.useEffect)(() => {
    if (dataView && !dataView.isPersisted()) {
      trackUiMetric === null || trackUiMetric === void 0 ? void 0 : trackUiMetric(_analytics.METRIC_TYPE.COUNT, _constants.ADHOC_DATA_VIEW_RENDER_EVENT);
    }
  }, [dataView, isEsqlMode, trackUiMetric]);

  /**
   * Takes care of checking data view id references in filters
   */
  (0, _use_filters_validation.useFiltersValidation)({
    savedSearch,
    filterManager,
    toastNotifications
  });
};
exports.useAdHocDataViews = useAdHocDataViews;