"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppMenuActionsMenuPopover = void 0;
exports.runAppMenuAction = runAppMenuAction;
exports.runAppMenuPopoverAction = runAppMenuPopoverAction;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _eui = require("@elastic/eui");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _public = require("@kbn/kibana-react-plugin/public");
var _discoverUtils = require("@kbn/discover-utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/top_nav/app_menu_actions/run_app_menu_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const container = document.createElement('div');
let isOpen = false;
const AppMenuActionsMenuPopover = ({
  appMenuItem,
  anchorElement,
  onClose: originalOnClose
}) => {
  const [nestedContent, setNestedContent] = (0, _react.useState)();
  const onClose = (0, _react.useCallback)(() => {
    originalOnClose();
    anchorElement === null || anchorElement === void 0 ? void 0 : anchorElement.focus();
  }, [anchorElement, originalOnClose]);
  const items = appMenuItem.actions.map((action, i) => {
    if (action.type === _discoverUtils.AppMenuActionType.submenuHorizontalRule) {
      if (i === 0 || i === appMenuItem.actions.length - 1) {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
      } else {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
          key: action.id,
          "data-test-subj": action.testId,
          margin: "none",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 66,
            columnNumber: 16
          }
        });
      }
    }
    const controlProps = action.controlProps;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: action.id,
      "data-test-subj": controlProps.testId,
      disabled: typeof controlProps.disableButton === 'function' ? controlProps.disableButton() : Boolean(controlProps.disableButton),
      toolTipContent: typeof controlProps.tooltip === 'function' ? controlProps.tooltip() : controlProps.tooltip,
      icon: controlProps.iconType,
      href: controlProps.href,
      onClick: async () => {
        var _controlProps$onClick;
        const result = await ((_controlProps$onClick = controlProps.onClick) === null || _controlProps$onClick === void 0 ? void 0 : _controlProps$onClick.call(controlProps, {
          anchorElement,
          onFinishAction: onClose
        }));
        if (result) {
          setNestedContent(result);
        }
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 7
      }
    }, controlProps.label);
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, nestedContent, /*#__PURE__*/_react.default.createElement(_eui.EuiWrappingPopover, {
    ownFocus: true,
    button: anchorElement,
    closePopover: onClose,
    isOpen: !nestedContent,
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  })));
};
exports.AppMenuActionsMenuPopover = AppMenuActionsMenuPopover;
function cleanup() {
  if (!isOpen) {
    return;
  }
  _reactDom.default.unmountComponentAtNode(container);
  document.body.removeChild(container);
  isOpen = false;
}
function runAppMenuPopoverAction({
  appMenuItem,
  anchorElement,
  services
}) {
  if (isOpen) {
    cleanup();
    return;
  }
  isOpen = true;
  document.body.appendChild(container);
  const element = /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, services.core, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: services,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(AppMenuActionsMenuPopover, {
    appMenuItem: appMenuItem,
    anchorElement: anchorElement,
    services: services,
    onClose: cleanup,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 9
    }
  })));
  _reactDom.default.render(element, container);
}
async function runAppMenuAction({
  appMenuItem,
  anchorElement,
  services
}) {
  var _controlProps$onClick2;
  cleanup();
  const controlProps = appMenuItem.controlProps;
  const result = await ((_controlProps$onClick2 = controlProps.onClick) === null || _controlProps$onClick2 === void 0 ? void 0 : _controlProps$onClick2.call(controlProps, {
    anchorElement,
    onFinishAction: () => {
      cleanup();
      anchorElement === null || anchorElement === void 0 ? void 0 : anchorElement.focus();
    }
  }));
  if (!result) {
    return;
  }
  isOpen = true;
  document.body.appendChild(container);
  const element = /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, services.core, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: services,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 7
    }
  }, result));
  _reactDom.default.render(element, container);
}