"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldStatisticsTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_query_subscriber = require("@kbn/unified-field-list/src/hooks/use_query_subscriber");
var _rxjs = require("rxjs");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _field_stats_table = require("./field_stats_table");
var _use_is_esql_mode = require("../../hooks/use_is_esql_mode");
var _redux = require("../../state_management/redux");
var _types = require("../../../types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/field_stats_table/field_stats_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FieldStatisticsTab = exports.FieldStatisticsTab = /*#__PURE__*/_react.default.memo(props => {
  var _services$dataVisuali;
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    query,
    filters
  } = (0, _use_query_subscriber.useQuerySubscriber)({
    data: services.data
  });
  const isEsql = (0, _use_is_esql_mode.useIsEsqlMode)();
  const hideAggregatedPreview = (0, _redux.useAppStateSelector)(state => state.hideAggregatedPreview);
  const lastReloadRequestTime$ = (0, _react.useMemo)(() => {
    return props.stateContainer.dataState.refetch$.pipe((0, _rxjs.map)(() => Date.now()));
  }, [props.stateContainer]);
  const lastReloadRequestTime = (0, _useObservable.default)(lastReloadRequestTime$);
  const totalHitsComplete$ = (0, _react.useMemo)(() => {
    return props.stateContainer.dataState.data$.totalHits$.pipe((0, _rxjs.filter)(d => d.fetchStatus === _types.FetchStatus.COMPLETE), (0, _rxjs.map)(d => d.result));
  }, [props.stateContainer]);
  const totalHits = (0, _useObservable.default)(totalHitsComplete$);
  const dispatch = (0, _redux.useInternalStateDispatch)();
  const updateAppState = (0, _redux.useCurrentTabAction)(_redux.internalStateActions.updateAppState);
  const updateState = (0, _react.useCallback)(changes => {
    if (changes.showDistributions !== undefined) {
      dispatch(updateAppState({
        appState: {
          hideAggregatedPreview: !changes.showDistributions
        }
      }));
    }
  }, [dispatch, updateAppState]);

  // Quit early if we know it's in ES|QL mode
  if (isEsql && (_services$dataVisuali = services.dataVisualizer) !== null && _services$dataVisuali !== void 0 && _services$dataVisuali.FieldStatsUnavailableMessage) {
    return /*#__PURE__*/_react.default.createElement(services.dataVisualizer.FieldStatsUnavailableMessage, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_field_stats_table.FieldStatisticsTable, {
    dataView: props.dataView,
    columns: props.columns,
    onAddFilter: props.onAddFilter,
    trackUiMetric: props.trackUiMetric,
    isEsqlMode: props.isEsqlMode,
    query: query,
    filters: filters,
    lastReloadRequestTime: lastReloadRequestTime,
    hideAggregatedPreview: hideAggregatedPreview,
    totalHits: totalHits,
    updateState: updateState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  });
});