"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDatasetQualityDetailsState = void 0;
var _react = require("react");
var _react2 = require("@xstate/react");
var _context = require("../components/dataset_quality_details/context");
var _utils = require("../../common/utils");
var _utils2 = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDatasetQualityDetailsState = () => {
  var _useSelector, _dataStreamSettings$d, _dataStreamSettings$d2, _dataStreamSettings$d3, _dataStreamSettings$d4, _dataStreamSettings$d5, _dataStreamSettings$d6, _dataStreamSettings$d7;
  const {
    service,
    telemetryClient
  } = (0, _context.useDatasetQualityDetailsContext)();
  const {
    services: {
      fieldFormats
    }
  } = (0, _utils2.useKibanaContextForPlugin)();
  const {
    dataStream,
    qualityIssues,
    timeRange,
    breakdownField,
    isIndexNotFoundError,
    expandedQualityIssue,
    view,
    streamDefinition
  } = (_useSelector = (0, _react2.useSelector)(service, state => state.context)) !== null && _useSelector !== void 0 ? _useSelector : {};
  const isNonAggregatable = (0, _react2.useSelector)(service, state => state.matches('initializing.nonAggregatableDataset.done') ? state.context.isNonAggregatable : false);
  const isBreakdownFieldEcs = (0, _react2.useSelector)(service, state => state.matches('initializing.checkBreakdownFieldIsEcs.done') ? state.context.isBreakdownFieldEcs : false);
  const isBreakdownFieldAsserted = (0, _react2.useSelector)(service, state => state.matches('initializing.checkBreakdownFieldIsEcs.done') && breakdownField && isBreakdownFieldEcs);
  const dataStreamSettings = (0, _react2.useSelector)(service, state => state.matches('initializing.dataStreamSettings.qualityIssues.dataStreamDegradedFields.fetchingDataStreamDegradedFields') || state.matches('initializing.dataStreamSettings.doneFetchingQualityIssues') || state.matches('initializing.dataStreamSettings.qualityIssues.dataStreamDegradedFields.errorFetchingDegradedFields') || state.matches('initializing.dataStreamSettings.qualityIssues.dataStreamFailedDocs.fetchingFailedDocs') || state.matches('initializing.dataStreamSettings.qualityIssues.dataStreamFailedDocs.errorFetchingFailedDocs') ? state.context.dataStreamSettings : undefined);
  const integrationDetails = {
    integration: (0, _react2.useSelector)(service, state => state.matches('initializing.checkAndLoadIntegrationAndDashboards.loadingIntegrationDashboards') || state.matches('initializing.checkAndLoadIntegrationAndDashboards.unauthorizedToLoadDashboards') || state.matches('initializing.checkAndLoadIntegrationAndDashboards.done') ? state.context.integration : undefined),
    dashboard: (0, _react2.useSelector)(service, state => state.matches('initializing.checkAndLoadIntegrationAndDashboards.done') ? state.context.integrationDashboards : undefined)
  };
  const canUserAccessDashboards = (0, _react2.useSelector)(service, state => !state.matches('initializing.checkAndLoadIntegrationAndDashboards.unauthorizedToLoadDashboards'));
  const canUserViewIntegrations = Boolean(dataStreamSettings === null || dataStreamSettings === void 0 ? void 0 : (_dataStreamSettings$d = dataStreamSettings.datasetUserPrivileges) === null || _dataStreamSettings$d === void 0 ? void 0 : _dataStreamSettings$d.canViewIntegrations);
  const canUserReadFailureStore = Boolean(dataStreamSettings === null || dataStreamSettings === void 0 ? void 0 : (_dataStreamSettings$d2 = dataStreamSettings.datasetUserPrivileges) === null || _dataStreamSettings$d2 === void 0 ? void 0 : (_dataStreamSettings$d3 = _dataStreamSettings$d2.datasetsPrivilages) === null || _dataStreamSettings$d3 === void 0 ? void 0 : (_dataStreamSettings$d4 = _dataStreamSettings$d3[dataStream]) === null || _dataStreamSettings$d4 === void 0 ? void 0 : _dataStreamSettings$d4.canReadFailureStore);
  const canUserManageFailureStore = Boolean(dataStreamSettings === null || dataStreamSettings === void 0 ? void 0 : (_dataStreamSettings$d5 = dataStreamSettings.datasetUserPrivileges) === null || _dataStreamSettings$d5 === void 0 ? void 0 : (_dataStreamSettings$d6 = _dataStreamSettings$d5.datasetsPrivilages) === null || _dataStreamSettings$d6 === void 0 ? void 0 : (_dataStreamSettings$d7 = _dataStreamSettings$d6[dataStream]) === null || _dataStreamSettings$d7 === void 0 ? void 0 : _dataStreamSettings$d7.canManageFailureStore);
  const dataStreamDetails = (0, _react2.useSelector)(service, state => state.matches('initializing.dataStreamDetails.done') ? state.context.dataStreamDetails : undefined);
  const {
    type,
    dataset,
    namespace
  } = (0, _utils.indexNameToDataStreamParts)(dataStream);
  const datasetDetails = {
    type,
    name: dataset,
    namespace,
    rawName: dataStream
  };
  const docsTrendChart = (0, _react2.useSelector)(service, state => state.context.qualityIssuesChart);
  const loadingState = (0, _react2.useSelector)(service, state => ({
    nonAggregatableDatasetLoading: state.matches('initializing.nonAggregatableDataset.fetching'),
    dataStreamDetailsLoading: state.matches('initializing.dataStreamDetails.fetching'),
    dataStreamSettingsLoading: state.matches('initializing.dataStreamSettings.fetchingDataStreamSettings'),
    integrationDetailsLoading: state.matches('initializing.checkAndLoadIntegrationAndDashboards.checkingAndLoadingIntegration'),
    integrationDetailsLoaded: state.matches('initializing.checkAndLoadIntegrationAndDashboards.loadingIntegrationDashboards') || state.matches('initializing.checkAndLoadIntegrationAndDashboards.unauthorizedToLoadDashboards') || state.matches('initializing.checkAndLoadIntegrationAndDashboards.done'),
    integrationDashboardsLoading: state.matches('initializing.checkAndLoadIntegrationAndDashboards.loadingIntegrationDashboards')
  }));
  const isQualityIssueFlyoutOpen = (0, _react2.useSelector)(service, state => state.matches('initializing.qualityIssueFlyout.open'));
  const updateTimeRange = (0, _react.useCallback)(({
    start,
    end
  }) => {
    service.send({
      type: 'UPDATE_TIME_RANGE',
      timeRange: {
        ...timeRange,
        from: start,
        to: end
      }
    });
  }, [service, timeRange]);
  const updateFailureStore = (0, _react.useCallback)(({
    failureStoreDataQualityConfig,
    failureStoreStreamConfig
  }) => {
    service.send({
      type: 'UPDATE_FAILURE_STORE',
      data: {
        ...dataStreamDetails,
        failureStoreDataQualityConfig,
        failureStoreStreamConfig
      }
    });
  }, [dataStreamDetails, service]);
  const hasFailureStore = Boolean(dataStreamDetails === null || dataStreamDetails === void 0 ? void 0 : dataStreamDetails.hasFailureStore);
  const canShowFailureStoreInfo = canUserReadFailureStore && hasFailureStore;
  const defaultRetentionPeriod = dataStreamDetails === null || dataStreamDetails === void 0 ? void 0 : dataStreamDetails.defaultRetentionPeriod;
  const customRetentionPeriod = dataStreamDetails === null || dataStreamDetails === void 0 ? void 0 : dataStreamDetails.customRetentionPeriod;
  return {
    service,
    telemetryClient,
    fieldFormats,
    isIndexNotFoundError,
    dataStream,
    datasetDetails,
    qualityIssues,
    dataStreamDetails,
    docsTrendChart,
    breakdownField,
    isBreakdownFieldEcs,
    isBreakdownFieldAsserted,
    isNonAggregatable,
    timeRange,
    loadingState,
    updateTimeRange,
    updateFailureStore,
    dataStreamSettings,
    integrationDetails,
    canUserAccessDashboards,
    canUserViewIntegrations,
    canUserReadFailureStore,
    hasFailureStore,
    canShowFailureStoreInfo,
    expandedQualityIssue,
    isQualityIssueFlyoutOpen,
    view,
    defaultRetentionPeriod,
    customRetentionPeriod,
    canUserManageFailureStore,
    streamDefinition
  };
};
exports.useDatasetQualityDetailsState = useDatasetQualityDetailsState;