"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggregationNotSupported = AggregationNotSupported;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/overview/aggregation_not_supported.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const aggregationNotSupportedTitle = _i18n.i18n.translate('xpack.datasetQuality.nonAggregatable.title', {
  defaultMessage: 'Your request may take longer to complete'
});
const aggregationNotSupportedDescription = dataset => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.datasetQuality.flyout.nonAggregatable.description",
  defaultMessage: "{description}",
  values: {
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.datasetQuality.flyout.nonAggregatable.warning",
      defaultMessage: "{dataset}does not support _ignored aggregation and may cause delays when querying data. {howToFixIt}",
      values: {
        dataset: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          language: "json",
          transparentBackground: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 28,
            columnNumber: 15
          }
        }, dataset),
        howToFixIt: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.datasetQuality.flyout.nonAggregatable.howToFixIt",
          defaultMessage: "Manually {rolloverLink} this data set to prevent future delays.",
          values: {
            rolloverLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
              external: true,
              target: "_blank",
              "data-test-subj": "datasetQualityFlyoutNonAggregatableHowToFixItLink",
              href: "https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-rollover-index.html",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 38,
                columnNumber: 21
              }
            }, _i18n.i18n.translate('xpack.datasetQuality.flyout.nonAggregatableDatasets.link.title', {
              defaultMessage: 'rollover'
            }))
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 33,
            columnNumber: 15
          }
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 23,
        columnNumber: 9
      }
    })
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 18,
    columnNumber: 3
  }
});
function AggregationNotSupported({
  dataStream
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "datasetQualityFlyoutNonAggregatableWarning",
    style: {
      marginBottom: '24px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: aggregationNotSupportedTitle,
    color: "warning",
    iconType: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, aggregationNotSupportedDescription(dataStream)))));
}