"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Selector = Selector;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality/filters/selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const selectorLoading = _i18n.i18n.translate('xpack.datasetQuality.selector.loading', {
  defaultMessage: 'Loading'
});
function Selector({
  dataTestSubj = 'datasetQualitySelectable',
  isLoading,
  options,
  loadingMessage,
  label,
  searchPlaceholder,
  noneAvailableMessage,
  noneMatchingMessage,
  onOptionsChange
}) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const closePopover = () => {
    setIsPopoverOpen(false);
  };
  const renderOption = option => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": `${dataTestSubj}Option-${option.label}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, option.label);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    "data-test-subj": `${dataTestSubj}Button`,
    iconType: "arrowDown",
    badgeColor: "success",
    onClick: onButtonClick,
    isSelected: isPopoverOpen,
    numFilters: options.length,
    hasActiveFilters: !!options.find(item => item.checked === 'on'),
    numActiveFilters: options.filter(item => item.checked === 'on').length,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, label);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "data-test-subj": `${dataTestSubj}Options`,
    searchable: true,
    searchProps: {
      placeholder: searchPlaceholder,
      compressed: true
    },
    "aria-label": label,
    options: options,
    onChange: onOptionsChange,
    isLoading: isLoading,
    loadingMessage: loadingMessage !== null && loadingMessage !== void 0 ? loadingMessage : selectorLoading,
    emptyMessage: noneAvailableMessage,
    noMatchesMessage: noneMatchingMessage,
    renderOption: option => renderOption(option),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }, search), list)));
}