"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExistingIndexTemplate = exports.getExistingDataStream = void 0;
var _elasticsearch = require("@elastic/elasticsearch");
var _retry_es = require("../retry_es");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getExistingIndexTemplate = async (elasticsearchClient, dataStreamName) => {
  let existingIndexTemplate;
  try {
    ({
      index_templates: [existingIndexTemplate]
    } = await (0, _retry_es.retryEs)(() => elasticsearchClient.indices.getIndexTemplate({
      name: dataStreamName
    })));
  } catch (error) {
    if (error instanceof _elasticsearch.errors.ResponseError && error.statusCode === 404) {
      // Index template does not exist, we will create it
    } else {
      throw error;
    }
  }
  return existingIndexTemplate;
};
exports.getExistingIndexTemplate = getExistingIndexTemplate;
const getExistingDataStream = async (elasticsearchClient, dataStreamName) => {
  let existingDataStream;
  try {
    ({
      data_streams: [existingDataStream]
    } = await (0, _retry_es.retryEs)(() => elasticsearchClient.indices.getDataStream({
      name: dataStreamName
    })));
  } catch (error) {
    if (error instanceof _elasticsearch.errors.ResponseError && error.statusCode === 404) {
      // Data stream does not exist, we will create it
    } else {
      throw error;
    }
  }
  return existingDataStream;
};
exports.getExistingDataStream = getExistingDataStream;