"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _initialize = require("./initialize");
var _validate_client_args = require("./validate_client_args");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class DataStreamClient {
  constructor(client, dataStreamDefinition) {
    var _dataStreamDefinition;
    (0, _defineProperty2.default)(this, "runtimeFields", void 0);
    (0, _defineProperty2.default)(this, "helpers", {
      getFieldsFromHit: hit => {
        var _hit$fields;
        const fields = (_hit$fields = hit.fields) !== null && _hit$fields !== void 0 ? _hit$fields : {};
        return fields;
      }
    });
    this.client = client;
    this.dataStreamDefinition = dataStreamDefinition;
    this.runtimeFields = Object.keys((_dataStreamDefinition = dataStreamDefinition.searchRuntimeMappings) !== null && _dataStreamDefinition !== void 0 ? _dataStreamDefinition : {});
  }

  /**
   * This function ensures setup has been run before returning an instance of the client.
   *
   * @remark This function should execute early in the application lifecycle and preferably once per
   *         data stream. However, it should be idempotent.
   */
  static async initialize(args) {
    (0, _validate_client_args.validateClientArgs)(args);
    const {
      dataStreamReady
    } = await (0, _initialize.initialize)({
      ...args,
      lazyCreation: args.lazyCreation
    });
    if (!dataStreamReady) {
      return;
    }
    return new DataStreamClient(args.elasticsearchClient, args.dataStream);
  }
  async index(args) {
    return this.client.index({
      ...args,
      index: this.dataStreamDefinition.name
    });
  }
  async bulk(args) {
    return this.client.bulk({
      index: this.dataStreamDefinition.name,
      ...args
    });
  }
  async get(args) {
    return this.client.get({
      index: this.dataStreamDefinition.name,
      ...args
    });
  }
  async existsIndex() {
    return this.client.indices.exists({
      index: this.dataStreamDefinition.name
    });
  }
  async search(args, transportOpts) {
    return this.client.search({
      index: this.dataStreamDefinition.name,
      runtime_mappings: this.dataStreamDefinition.searchRuntimeMappings,
      fields: this.runtimeFields,
      ...args
    }, transportOpts);
  }
}
exports.DataStreamClient = DataStreamClient;