"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ACTION_VALUE_CLICK = void 0;
exports.createValueClickActionDefinition = createValueClickActionDefinition;
var _esQuery = require("@kbn/es-query");
var _triggers = require("../triggers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const ACTION_VALUE_CLICK = exports.ACTION_VALUE_CLICK = 'ACTION_VALUE_CLICK';
function createValueClickActionDefinition(getStartServices) {
  return {
    type: ACTION_VALUE_CLICK,
    id: ACTION_VALUE_CLICK,
    shouldAutoExecute: async () => true,
    isCompatible: async context => {
      const {
        createFiltersFromValueClickAction,
        appendFilterToESQLQueryFromValueClickAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./filters')));
      if (context.data.query && (0, _esQuery.isOfAggregateQueryType)(context.data.query)) {
        const queryString = await appendFilterToESQLQueryFromValueClickAction(context.data);
        return queryString != null;
      }
      const filters = await createFiltersFromValueClickAction(context.data);
      return filters.length > 0;
    },
    execute: async context => {
      try {
        if (context.data.query && (0, _esQuery.isOfAggregateQueryType)(context.data.query)) {
          // ES|QL charts have a different way of applying filters,
          // they are appending a where clause to the query

          const {
            appendFilterToESQLQueryFromValueClickAction
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./filters')));
          const queryString = appendFilterToESQLQueryFromValueClickAction(context.data);
          await getStartServices().uiActions.getTrigger('UPDATE_ESQL_QUERY_TRIGGER').exec({
            queryString
          });
        } else {
          const {
            createFiltersFromValueClickAction
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./filters')));
          const filters = await createFiltersFromValueClickAction(context.data);
          if (filters.length > 0) {
            await getStartServices().uiActions.getTrigger(_triggers.APPLY_FILTER_TRIGGER).exec({
              filters,
              embeddable: context.embeddable,
              timeFieldName: context.data.timeFieldName
            });
          }
        }
      } catch (e) {
        // eslint-disable-next-line no-console
        console.warn(`Error [ACTION_EMIT_APPLY_FILTER_TRIGGER]: can\'t extract filters from action context`);
      }
    }
  };
}