"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.kibana = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const toArray = query => !query ? [] : Array.isArray(query) ? query : [query];
const kibana = exports.kibana = {
  name: 'kibana',
  type: 'kibana_context',
  inputTypes: ['kibana_context', 'null'],
  help: _i18n.i18n.translate('data.search.functions.kibana.help', {
    defaultMessage: 'Gets kibana global context'
  }),
  args: {},
  fn(input, _, {
    getSearchContext
  }) {
    var _searchContext$now;
    const searchContext = getSearchContext();
    const output = {
      // TODO: This spread is left here for legacy reasons, possibly Lens uses it.
      // TODO: But it shouldn't be need.
      ...input,
      type: 'kibana_context',
      now: (_searchContext$now = searchContext.now) !== null && _searchContext$now !== void 0 ? _searchContext$now : Date.now(),
      query: [...toArray(searchContext.query), ...toArray((input || {}).query)],
      filters: [...(searchContext.filters || []), ...((input || {}).filters || [])],
      timeRange: searchContext.timeRange || (input ? input.timeRange : undefined),
      esqlVariables: searchContext.esqlVariables || (input ? input.esqlVariables : undefined),
      projectRouting: searchContext.projectRouting || (input ? input.projectRouting : undefined)
    };
    return output;
  }
};