"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangeKey = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _serializable_field = require("../../../serializable_field");
var _serialize_utils = require("../../../serialize_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Serialized form of {@link @kbn/data-plugin/common.RangeKey}
 */

function findCustomLabel(from, to, ranges) {
  var _find;
  return (_find = (ranges || []).find(range => (from == null && range.from == null || range.from === from) && (to == null && range.to == null || range.to === to))) === null || _find === void 0 ? void 0 : _find.label;
}
const getRangeValue = (bucket, key) => {
  const value = bucket && typeof bucket === 'object' && key in bucket && bucket[key];
  return value == null || ['string', 'number'].includes(typeof value) ? value : null;
};
const getRangeFromBucket = bucket => {
  return {
    from: getRangeValue(bucket, 'from'),
    to: getRangeValue(bucket, 'to')
  };
};
const regex = /^from:(-?\d+?|undefined),to:(-?\d+?|undefined)$/;
class RangeKey extends _serializable_field.SerializableField {
  static isInstance(field) {
    return field instanceof RangeKey;
  }
  static deserialize(value) {
    const {
      to,
      from,
      ranges
    } = value;
    return new RangeKey({
      to,
      from
    }, ranges);
  }
  static idBucket(bucket) {
    const {
      from,
      to
    } = getRangeFromBucket(bucket);
    return `from:${from},to:${to}`;
  }
  static isRangeKeyString(rangeKey) {
    return regex.test(rangeKey);
  }

  /**
   * Returns `RangeKey` from stringified form. Cannot extract labels from stringified form.
   *
   * Only supports numerical (non-string) values.
   */
  static fromString(rangeKey) {
    var _regex$exec;
    const [from, to] = ((_regex$exec = regex.exec(rangeKey)) !== null && _regex$exec !== void 0 ? _regex$exec : []).slice(1).map(Number).map(n => isNaN(n) ? undefined : n);
    return new RangeKey({
      from,
      to
    });
  }
  constructor(bucket, allRanges) {
    super();
    (0, _defineProperty2.default)(this, "gte", void 0);
    (0, _defineProperty2.default)(this, "lt", void 0);
    (0, _defineProperty2.default)(this, "label", void 0);
    const {
      from,
      to
    } = getRangeFromBucket(bucket);
    this.gte = from == null ? -Infinity : from;
    this.lt = to == null ? +Infinity : to;
    this.label = findCustomLabel(from, to, allRanges);
  }
  toString() {
    return `from:${this.gte},to:${this.lt}`;
  }
  serialize() {
    const from = typeof this.gte === 'string' || isFinite(this.gte) ? this.gte : null;
    const to = typeof this.lt === 'string' || isFinite(this.lt) ? this.lt : null;
    return {
      type: _serialize_utils.SerializableType.RangeKey,
      from,
      to,
      ranges: this.label === undefined ? [] : [{
        from,
        to,
        label: this.label
      }]
    };
  }
}
exports.RangeKey = RangeKey;