"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerUpdateRoute = registerUpdateRoute;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../constants");
var _schemas = require("./schemas");
var _update = require("./update");
var _dashboard_state_schemas = require("../dashboard_state_schemas");
var _scope_tooling = require("../scope_tooling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function registerUpdateRoute(router) {
  const updateRoute = router.put({
    path: `${_constants.PUBLIC_API_PATH}/{id}`,
    summary: `Replace current dashboard state with the dashboard state from request body.`,
    ..._constants.commonRouteConfig
  });
  updateRoute.addVersion({
    version: _constants.INTERNAL_API_VERSION,
    validate: () => ({
      request: {
        params: _configSchema.schema.object({
          id: _configSchema.schema.string({
            meta: {
              description: 'A unique identifier for the dashboard.'
            }
          })
        }),
        query: _configSchema.schema.maybe(_configSchema.schema.object({
          allowUnmappedKeys: _configSchema.schema.maybe(_dashboard_state_schemas.allowUnmappedKeysSchema)
        })),
        body: (0, _schemas.getUpdateRequestBodySchema)()
      },
      response: {
        200: {
          body: _schemas.getUpdateResponseBodySchema
        }
      }
    })
  }, async (ctx, req, res) => {
    try {
      var _req$query$allowUnmap, _req$query;
      const allowUnmappedKeys = (_req$query$allowUnmap = (_req$query = req.query) === null || _req$query === void 0 ? void 0 : _req$query.allowUnmappedKeys) !== null && _req$query$allowUnmap !== void 0 ? _req$query$allowUnmap : false;
      if (!allowUnmappedKeys) (0, _scope_tooling.throwOnUnmappedKeys)(req.body.data);
      const result = await (0, _update.update)(ctx, req.params.id, req.body);
      return res.ok({
        body: result
      });
    } catch (e) {
      if (e.isBoom && e.output.statusCode === 404) {
        return res.notFound({
          body: {
            message: `A dashboard with ID ${req.params.id} was not found.`
          }
        });
      }
      if (e.isBoom && e.output.statusCode === 403) {
        return res.forbidden();
      }
      return res.badRequest({
        body: e.output.payload
      });
    }
  });
}