"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformTagsIn = transformTagsIn;
var _common = require("@kbn/saved-objects-tagging-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function transformTagsIn(tags) {
  const uniqueTagIds = new Set([]);
  (tags !== null && tags !== void 0 ? tags : []).forEach(tagId => {
    uniqueTagIds.add(tagId);
  });
  return Array.from(uniqueTagIds).map(tagId => ({
    type: _common.tagSavedObjectTypeName,
    id: tagId,
    name: `tag-ref-${tagId}`
  }));
}