"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usageCollectionService = exports.urlForwardingService = exports.untilPluginStartServicesReady = exports.uiActionsService = exports.spacesService = exports.shareService = exports.setKibanaServices = exports.serverlessService = exports.screenshotModeService = exports.savedObjectsTaggingService = exports.presentationUtilService = exports.observabilityAssistantService = exports.noDataPageService = exports.navigationService = exports.lensService = exports.fieldFormatService = exports.embeddableService = exports.dataViewEditorService = exports.dataService = exports.cpsService = exports.coreServices = exports.contentManagementService = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

let coreServices = exports.coreServices = void 0;
let cpsService = exports.cpsService = void 0;
let contentManagementService = exports.contentManagementService = void 0;
let dataService = exports.dataService = void 0;
let dataViewEditorService = exports.dataViewEditorService = void 0;
let embeddableService = exports.embeddableService = void 0;
let fieldFormatService = exports.fieldFormatService = void 0;
let navigationService = exports.navigationService = void 0;
let noDataPageService = exports.noDataPageService = void 0;
let observabilityAssistantService = exports.observabilityAssistantService = void 0;
let lensService = exports.lensService = void 0;
let presentationUtilService = exports.presentationUtilService = void 0;
let savedObjectsTaggingService = exports.savedObjectsTaggingService = void 0;
let screenshotModeService = exports.screenshotModeService = void 0;
let serverlessService = exports.serverlessService = void 0;
let shareService = exports.shareService = void 0;
let spacesService = exports.spacesService = void 0;
let uiActionsService = exports.uiActionsService = void 0;
let urlForwardingService = exports.urlForwardingService = void 0;
let usageCollectionService = exports.usageCollectionService = void 0;
const servicesReady$ = new _rxjs.BehaviorSubject(false);
const setKibanaServices = (kibanaCore, deps) => {
  exports.coreServices = coreServices = kibanaCore;
  exports.cpsService = cpsService = deps.cps;
  exports.contentManagementService = contentManagementService = deps.contentManagement;
  exports.dataService = dataService = deps.data;
  exports.dataViewEditorService = dataViewEditorService = deps.dataViewEditor;
  exports.embeddableService = embeddableService = deps.embeddable;
  exports.fieldFormatService = fieldFormatService = deps.fieldFormats;
  exports.navigationService = navigationService = deps.navigation;
  exports.noDataPageService = noDataPageService = deps.noDataPage;
  exports.observabilityAssistantService = observabilityAssistantService = deps.observabilityAIAssistant;
  exports.lensService = lensService = deps.lens;
  exports.presentationUtilService = presentationUtilService = deps.presentationUtil;
  exports.savedObjectsTaggingService = savedObjectsTaggingService = deps.savedObjectsTaggingOss;
  exports.serverlessService = serverlessService = deps.serverless;
  exports.screenshotModeService = screenshotModeService = deps.screenshotMode;
  exports.shareService = shareService = deps.share;
  exports.spacesService = spacesService = deps.spaces;
  exports.uiActionsService = uiActionsService = deps.uiActions;
  exports.urlForwardingService = urlForwardingService = deps.urlForwarding;
  exports.usageCollectionService = usageCollectionService = deps.usageCollection;
  servicesReady$.next(true);
};
exports.setKibanaServices = setKibanaServices;
const untilPluginStartServicesReady = () => {
  if (servicesReady$.value) return Promise.resolve();
  return new Promise(resolve => {
    const subscription = servicesReady$.subscribe(isInitialized => {
      if (isInitialized) {
        subscription.unsubscribe();
        resolve();
      }
    });
  });
};
exports.untilPluginStartServicesReady = untilPluginStartServicesReady;