"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _public = require("@kbn/core/public");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-utils-plugin/common");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _locator = require("../common/locator/locator");
var _page_bundle_constants = require("../common/page_bundle_constants");
var _panel_placement = require("./panel_placement");
var _kibana_services = require("./services/kibana_services");
var _logger = require("./services/logger");
var _register_actions = require("./dashboard_actions/register_actions");
var _setup_url_forwarding = require("./dashboard_app/url/setup_url_forwarding");
var _dashboard_duration_start_mark = require("./dashboard_api/performance/dashboard_duration_start_mark");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// eslint-disable-next-line @typescript-eslint/no-empty-interface

class DashboardPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "appStateUpdater", new _rxjs.BehaviorSubject(() => ({})));
    (0, _defineProperty2.default)(this, "stopUrlTracking", undefined);
    (0, _defineProperty2.default)(this, "currentHistory", undefined);
    (0, _logger.setLogger)(initializerContext.logger.get('dashboard'));
  }
  setup(core, {
    share,
    home,
    data,
    urlForwarding
  }) {
    core.analytics.registerEventType({
      eventType: 'dashboard_loaded_with_data',
      schema: {}
    });
    if (share) {
      share.url.locators.create(new _locator.DashboardAppLocatorDefinition({
        useHashedUrl: core.uiSettings.get('state:storeInSessionStorage'),
        getDashboardFilterFields: async dashboardId => {
          var _result$data$filters;
          const [{
            dashboardClient
          }] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('./dashboard_client'))), (0, _kibana_services.untilPluginStartServicesReady)()]);
          const result = await dashboardClient.get(dashboardId);
          return (_result$data$filters = result.data.filters) !== null && _result$data$filters !== void 0 ? _result$data$filters : [];
        }
      }));
    }
    const {
      appMounted,
      appUnMounted,
      stop: stopUrlTracker,
      restorePreviousUrl
    } = (0, _public2.createKbnUrlTracker)({
      baseUrl: core.http.basePath.prepend('/app/dashboards'),
      defaultSubUrl: `#${_page_bundle_constants.LANDING_PAGE_PATH}`,
      storageKey: `lastUrl:${core.http.basePath.get()}:dashboard`,
      navLinkUpdater$: this.appStateUpdater,
      toastNotifications: core.notifications.toasts,
      stateParams: [{
        kbnUrlKey: '_g',
        stateUpdate$: data.query.state$.pipe((0, _rxjs.filter)(({
          changes
        }) => !!(changes.globalFilters || changes.time || changes.refreshInterval)), (0, _rxjs.map)(async ({
          state
        }) => {
          var _state$filters;
          const {
            isFilterPinned
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
          return {
            ...state,
            filters: (_state$filters = state.filters) === null || _state$filters === void 0 ? void 0 : _state$filters.filter(isFilterPinned)
          };
        }))
      }],
      getHistory: () => this.currentHistory,
      onBeforeNavLinkSaved: newNavLink => {
        // Do not save SEARCH_SESSION_ID into nav link, because of possible edge cases
        // that could lead to session restoration failure.
        // see: https://github.com/elastic/kibana/issues/87149

        // We also don't want to store the table list view state.
        // The question is: what _do_ we want to save here? :)
        const tableListUrlState = ['s', 'title', 'sort', 'sortdir', 'created_by', 'favorites'];
        return (0, _common.replaceUrlHashQuery)(newNavLink, query => {
          [_page_bundle_constants.SEARCH_SESSION_ID, ...tableListUrlState].forEach(param => {
            delete query[param];
          });
          return query;
        });
      }
    });
    this.stopUrlTracking = () => {
      stopUrlTracker();
    };
    const app = {
      id: _page_bundle_constants.DASHBOARD_APP_ID,
      title: 'Dashboards',
      order: 2500,
      euiIconType: 'logoKibana',
      defaultPath: `#${_page_bundle_constants.LANDING_PAGE_PATH}`,
      updater$: this.appStateUpdater,
      category: _public.DEFAULT_APP_CATEGORIES.kibana,
      mount: async params => {
        performance.mark(_dashboard_duration_start_mark.DASHBOARD_DURATION_START_MARK);
        this.currentHistory = params.history;
        params.element.classList.add(_public.APP_WRAPPER_CLASS);
        const [{
          mountApp
        }] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('./dashboard_app/dashboard_router'))), Promise.resolve().then(() => _interopRequireWildcard(require('./dashboard_renderer/dashboard_module'))), (0, _kibana_services.untilPluginStartServicesReady)()]);
        appMounted();
        const [coreStart] = await core.getStartServices();
        const mountContext = {
          restorePreviousUrl,
          scopedHistory: () => this.currentHistory,
          onAppLeave: params.onAppLeave,
          setHeaderActionMenu: params.setHeaderActionMenu
        };
        return mountApp({
          coreStart,
          appUnMounted,
          element: params.element,
          mountContext
        });
      }
    };
    core.application.register(app);
    (0, _setup_url_forwarding.setupUrlForwarding)(urlForwarding);
    const dashboardAppTitle = _i18n.i18n.translate('dashboard.featureCatalogue.dashboardTitle', {
      defaultMessage: 'Dashboard'
    });
    if (home) {
      home.featureCatalogue.register({
        id: _page_bundle_constants.DASHBOARD_APP_ID,
        title: dashboardAppTitle,
        subtitle: _i18n.i18n.translate('dashboard.featureCatalogue.dashboardSubtitle', {
          defaultMessage: 'Analyze data in dashboards.'
        }),
        description: _i18n.i18n.translate('dashboard.featureCatalogue.dashboardDescription', {
          defaultMessage: 'Display and share a collection of visualizations and search results.'
        }),
        icon: 'dashboardApp',
        path: `/app/${_page_bundle_constants.DASHBOARD_APP_ID}#${_page_bundle_constants.LANDING_PAGE_PATH}`,
        showOnHomePage: false,
        category: 'data',
        solutionId: 'kibana',
        order: 100
      });
    }
    return {};
  }
  start(core, plugins) {
    (0, _kibana_services.setKibanaServices)(core, plugins);
    (0, _register_actions.registerActions)(plugins);
    plugins.uiActions.registerActionAsync('searchDashboardAction', async () => {
      const {
        searchAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./dashboard_client')));
      return searchAction;
    });
    plugins.uiActions.registerActionAsync('getDashboardsByIdsAction', async () => {
      const {
        getDashboardsByIdsAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./dashboard_client')));
      return getDashboardsByIdsAction;
    });
    return {
      registerDashboardPanelSettings: _panel_placement.registerDashboardPanelSettings,
      findDashboardsService: async () => {
        const {
          findService
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./dashboard_client')));
        return findService;
      }
    };
  }
  stop() {
    if (this.stopUrlTracking) {
      this.stopUrlTracking();
    }
  }
}
exports.DashboardPlugin = DashboardPlugin;