"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddPanelFlyout = AddPanelFlyout;
var _react = _interopRequireWildcard(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _get_menu_item_groups = require("../get_menu_item_groups");
var _groups = require("./groups");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_app/top_nav/add_panel_button/components/add_panel_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AddPanelFlyout({
  dashboardApi,
  closeFlyout,
  ariaLabelledBy
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    value: groups,
    loading,
    error
  } = (0, _useAsync.default)(async () => {
    return await (0, _get_menu_item_groups.getMenuItemGroups)(dashboardApi);
  }, [dashboardApi]);
  const [searchTerm, setSearchTerm] = (0, _react.useState)('');
  const [filteredGroups, setFilteredGroups] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    if (!searchTerm) {
      return setFilteredGroups(groups !== null && groups !== void 0 ? groups : []);
    }
    const q = searchTerm.toLowerCase();
    const currentGroups = groups !== null && groups !== void 0 ? groups : [];
    setFilteredGroups(currentGroups.map(group => {
      const groupMatch = group.title.toLowerCase().includes(q);
      const [itemsMatch, items] = group.items.reduce((acc, item) => {
        const itemMatch = item.name.toLowerCase().includes(q);
        acc[0] = acc[0] || itemMatch;
        acc[1].push({
          ...item,
          isDisabled: !(groupMatch || itemMatch)
        });
        return acc;
      }, [false, []]);
      return {
        ...group,
        isDisabled: !(groupMatch || itemsMatch),
        items
      };
    }).filter(group => !group.isDisabled));
  }, [groups, searchTerm]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    id: ariaLabelledBy,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "dashboard.solutionToolbar.addPanelFlyout.headingText",
    defaultMessage: "Add panel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    isLoading: loading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      position: 'sticky',
      top: euiTheme.size.m,
      zIndex: 1,
      boxShadow: `0 -${euiTheme.size.m} 0 4px ${euiTheme.colors.backgroundBasePlain}`
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    css: {
      backgroundColor: euiTheme.colors.backgroundBasePlain
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    autoFocus: true,
    compressed: true,
    value: searchTerm,
    onChange: e => {
      setSearchTerm(e.target.value);
    },
    "aria-label": _i18n.i18n.translate('dashboard.editorMenu.addPanelFlyout.searchLabelText', {
      defaultMessage: 'search field for panels'
    }),
    "data-test-subj": "dashboardPanelSelectionFlyout__searchInput",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      minHeight: '20vh',
      ...(error ? {
        justifyContent: 'center',
        alignItems: 'center'
      } : {})
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  }, error ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    iconColor: "danger",
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      textAlign: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "dashboard.solutionToolbar.addPanelFlyout.loadingErrorDescription",
      defaultMessage: "An error occurred loading the available dashboard panels for selection",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 23
      }
    })),
    "data-test-subj": "dashboardPanelSelectionErrorIndicator",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_groups.Groups, {
    groups: filteredGroups,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeFlyout,
    "data-test-subj": "dashboardPanelSelectionCloseBtn",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "dashboard.solutionToolbar.addPanelFlyout.cancelButtonText",
    defaultMessage: "Cancel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 15
    }
  }))))));
}