"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.COMPARE_DEBOUNCE = void 0;
exports.initializeProjectRoutingManager = initializeProjectRoutingManager;
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
var _kibana_services = require("../services/kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const COMPARE_DEBOUNCE = exports.COMPARE_DEBOUNCE = 100;
function initializeProjectRoutingManager(initialState, projectRoutingRestore$) {
  var _initialState$project;
  if (!(_kibana_services.cpsService !== null && _kibana_services.cpsService !== void 0 && _kibana_services.cpsService.cpsManager)) {
    return;
  }
  const cpsManager = _kibana_services.cpsService.cpsManager;
  const projectRouting$ = new _rxjs.BehaviorSubject(initialState.project_routing);

  // pass the initial state to CPS manager from dashboard state or just reset to default on dashboard init
  cpsManager.setProjectRouting((_initialState$project = initialState.project_routing) !== null && _initialState$project !== void 0 ? _initialState$project : cpsManager.getDefaultProjectRouting());
  function setProjectRouting(projectRouting) {
    if (projectRouting !== projectRouting$.value) {
      projectRouting$.next(projectRouting);
      cpsManager.setProjectRouting(projectRouting);
    }
  }

  // Subscribe to CPS's projectRouting$ to sync changes from the project picker
  const cpsProjectRoutingSubscription = cpsManager.getProjectRouting$().subscribe(cpsProjectRouting => {
    setProjectRouting(cpsProjectRouting);
  });
  const comparators = {
    project_routing: (_a, _b, lastSavedState, _latestState) => {
      if (!projectRoutingRestore$.value) return true;
      const savedValue = lastSavedState === null || lastSavedState === void 0 ? void 0 : lastSavedState.project_routing;
      return savedValue === projectRouting$.value;
    }
  };
  const getState = () => {
    if (!projectRoutingRestore$.value) {
      // Don't save anything when projectRestore is false
      return {};
    }

    // Read from CPS if available, otherwise use internal state
    return {
      project_routing: projectRouting$.value
    };
  };
  return {
    api: {
      projectRouting$,
      setProjectRouting
    },
    internalApi: {
      startComparing$: lastSavedState$ => {
        return projectRouting$.pipe((0, _rxjs.debounceTime)(COMPARE_DEBOUNCE), (0, _rxjs.map)(() => getState()), (0, _rxjs.combineLatestWith)(lastSavedState$), (0, _rxjs.map)(([latestState, lastSavedState]) => {
          return (0, _presentationPublishing.diffComparators)(comparators, lastSavedState, latestState);
        }));
      },
      comparators,
      getState,
      reset: lastSavedState => {
        var _lastSavedState$proje;
        setProjectRouting((_lastSavedState$proje = lastSavedState.project_routing) !== null && _lastSavedState$proje !== void 0 ? _lastSavedState$proje : cpsManager.getDefaultProjectRouting());
      }
    },
    cleanup: () => {
      cpsProjectRoutingSubscription === null || cpsProjectRoutingSubscription === void 0 ? void 0 : cpsProjectRoutingSubscription.unsubscribe();
    }
  };
}