"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CONTROL_GROUP_EMBEDDABLE_ID = void 0;
exports.initializeControlGroupManager = initializeControlGroupManager;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const CONTROL_GROUP_EMBEDDABLE_ID = exports.CONTROL_GROUP_EMBEDDABLE_ID = 'CONTROL_GROUP_EMBEDDABLE_ID';
function initializeControlGroupManager(initialState, getReferences, initialViewMode) {
  const controlGroupApi$ = new _rxjs.BehaviorSubject(undefined);
  async function untilControlsInitialized() {
    if (initialViewMode === 'print') return; // Controls are never initialized in print mode.
    return new Promise(resolve => {
      controlGroupApi$.pipe((0, _rxjs.skipWhile)(controlGroupApi => !controlGroupApi), (0, _rxjs.switchMap)(async controlGroupApi => {
        await (controlGroupApi === null || controlGroupApi === void 0 ? void 0 : controlGroupApi.untilFiltersPublished());
      }), (0, _rxjs.first)()).subscribe(() => {
        resolve();
      });
    });
  }
  const unPauseWhenControlsAreAvailable = async () => {
    await untilControlsInitialized();
    return false;
  };
  const isFetchPaused$ = (0, _rxjs.from)(unPauseWhenControlsAreAvailable()).pipe((0, _rxjs.startWith)(true));
  return {
    api: {
      controlGroupApi$,
      isFetchPaused$
    },
    internalApi: {
      getStateForControlGroup: () => {
        return {
          rawState: initialState ? initialState : {
            autoApplySelections: true,
            chainingSystem: 'HIERARCHICAL',
            controls: [],
            ignoreParentSettings: {
              ignoreFilters: false,
              ignoreQuery: false,
              ignoreTimerange: false,
              ignoreValidations: false
            },
            labelPosition: 'oneLine'
          },
          references: getReferences(CONTROL_GROUP_EMBEDDABLE_ID)
        };
      },
      serializeControlGroup: () => {
        var _controlGroupApi$$val, _serializedState$refe;
        const serializedState = (_controlGroupApi$$val = controlGroupApi$.value) === null || _controlGroupApi$$val === void 0 ? void 0 : _controlGroupApi$$val.serializeState();
        return {
          controlGroupInput: serializedState === null || serializedState === void 0 ? void 0 : serializedState.rawState,
          controlGroupReferences: (_serializedState$refe = serializedState === null || serializedState === void 0 ? void 0 : serializedState.references) !== null && _serializedState$refe !== void 0 ? _serializedState$refe : []
        };
      },
      setControlGroupApi: controlGroupApi => controlGroupApi$.next(controlGroupApi)
    }
  };
}