"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutService = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _rxjs = require("rxjs");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _overlay_mount_wrapper = require("../overlay_mount_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/overlays/browser-internal/src/flyout/flyout_service.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/* eslint-disable max-classes-per-file */
/**
 * A FlyoutRef is a reference to an opened flyout panel. It offers methods to
 * close the flyout panel again. If you open a flyout panel you should make
 * sure you call `close()` when it should be closed.
 * Since a flyout could also be closed by a user or from another flyout being
 * opened, you must bind to the `onClose` Promise on the FlyoutRef instance.
 * The Promise will resolve whenever the flyout was closed at which point you
 * should discard the FlyoutRef.
 *
 * @public
 */
class FlyoutRef {
  constructor() {
    /**
     * An Promise that will resolve once this flyout is closed.
     *
     * Flyouts can close from user interaction, calling `close()` on the flyout
     * reference or another call to `openFlyout()` replacing your flyout.
     */
    (0, _defineProperty2.default)(this, "onClose", void 0);
    (0, _defineProperty2.default)(this, "closeSubject", new _rxjs.Subject());
    this.onClose = this.closeSubject.toPromise();
  }

  /**
   * Closes the referenced flyout if it's still open which in turn will
   * resolve the `onClose` Promise. If the flyout had already been
   * closed this method does nothing.
   */
  close() {
    if (!this.closeSubject.closed) {
      this.closeSubject.next();
      this.closeSubject.complete();
    }
    return this.onClose;
  }
}
/** @internal */
class FlyoutService {
  constructor() {
    (0, _defineProperty2.default)(this, "activeFlyout", null);
    (0, _defineProperty2.default)(this, "targetDomElement", null);
  }
  start({
    analytics,
    i18n,
    theme,
    userProfile,
    targetDomElement
  }) {
    this.targetDomElement = targetDomElement;
    return {
      open: (mount, options = {}) => {
        const {
          isResizable,
          ...restOptions
        } = options;
        // If there is an active flyout session close it before opening a new one.
        if (this.activeFlyout) {
          this.activeFlyout.close();
          this.cleanupDom();
        }
        const flyout = new FlyoutRef();

        // If a flyout gets closed through it's FlyoutRef, remove it from the dom
        flyout.onClose.then(() => {
          if (this.activeFlyout === flyout) {
            this.cleanupDom();
          }
        });
        this.activeFlyout = flyout;
        const onCloseFlyout = () => {
          if (options.onClose) {
            options.onClose(flyout);
          } else {
            flyout.close();
          }
        };
        const getWrapper = children => {
          return isResizable ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutResizable, (0, _extends2.default)({}, restOptions, {
            onClose: onCloseFlyout,
            ref: /*#__PURE__*/_react.default.createRef(),
            maxWidth: Number(options === null || options === void 0 ? void 0 : options.maxWidth),
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 117,
              columnNumber: 13
            }
          }), children) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, (0, _extends2.default)({}, restOptions, {
            onClose: onCloseFlyout,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 126,
              columnNumber: 13
            }
          }), children);
        };
        (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, {
          analytics: analytics,
          i18n: i18n,
          theme: theme,
          userProfile: userProfile,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 133,
            columnNumber: 11
          }
        }, getWrapper(/*#__PURE__*/_react.default.createElement(_overlay_mount_wrapper.OverlayMountWrapper, {
          mount: mount,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 139,
            columnNumber: 25
          }
        }))), this.targetDomElement);
        return flyout;
      }
    };
  }

  /**
   * Using React.Render to re-render into a target DOM element will replace
   * the content of the target but won't call unmountComponent on any
   * components inside the target or any of their children. So we properly
   * cleanup the DOM here to prevent subtle bugs in child components which
   * depend on unmounting for cleanup behaviour.
   */
  cleanupDom() {
    if (this.targetDomElement != null) {
      (0, _reactDom.unmountComponentAtNode)(this.targetDomElement);
      this.targetDomElement.innerHTML = '';
    }
    this.activeFlyout = null;
  }
}
exports.FlyoutService = FlyoutService;