"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadApplication = loadApplication;
var _std = require("@kbn/std");
var _coreDiBrowser = require("@kbn/core-di-browser");
var _coreDiInternal = require("@kbn/core-di-internal");
var _coreDi = require("@kbn/core-di");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function loadApplication({
  bind,
  onActivation
}) {
  onActivation(_coreDiBrowser.Application, ({
    get
  }, definition) => {
    get((0, _coreDiBrowser.CoreSetup)('application')).register({
      ...definition,
      mount(params) {
        const scope = get((0, _coreDiBrowser.CoreStart)('injection')).fork();
        scope.bind(_coreDiBrowser.ApplicationParameters).toConstantValue(params);
        scope.bind(_coreDiInternal.Global).toConstantValue(_coreDiBrowser.ApplicationParameters);
        const unmount = scope.get(definition, {
          autobind: true
        }).mount();
        const wrap = callback => () => {
          try {
            return callback();
          } finally {
            scope.unbindAll();
          }
        };
        return (0, _std.isPromise)(unmount) ? unmount.then(wrap) : wrap(unmount);
      }
    });
    return definition;
  });
  bind(_coreDi.OnSetup).toConstantValue(container => {
    container.getAll(_coreDiBrowser.Application);
  });
}