"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommonGlobalAppStyles = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/layout/core-chrome-layout/layouts/common/global_app_styles.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// Due to pure HTML and the scope being large, we decided to temporarily apply following 4 style blocks globally.
// TODO: refactor within github issue #223571
const hackGlobalFieldFormattersPluginStyles = euiTheme => (0, _react.css)`
  // Styles applied to the span.ffArray__highlight from FieldFormat class that is used to visually distinguish array delimiters when rendering array values as HTML in Kibana field formatters
  .ffArray__highlight {
    color: ${euiTheme.colors.mediumShade};
  }

  // Styles applied to the span.ffSearch__highlight from FieldFormat class that is used to visually distinguish highlighted string values when rendering string values as HTML in Kibana field formatters
  .ffSearch__highlight {
    text-decoration: dotted underline;
  }

  // Styles applied to the span.ffString__emptyValue from FieldFormat class that is used to visually distinguish empty string values when rendering string values as HTML in Kibana field formatters
  .ffString__emptyValue {
    color: ${euiTheme.colors.darkShade};
  }

  .lnsTableCell--colored .ffString__emptyValue {
    color: unset;
  }
`;

/**
 * Global styles that are common for any type of layout.
 */
const CommonGlobalAppStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_react.Global, {
    styles: (0, _react.css)`
        ${hackGlobalFieldFormattersPluginStyles(euiTheme)}
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  });
};
exports.CommonGlobalAppStyles = CommonGlobalAppStyles;