"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOptionsListControlFactory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _esQuery = require("@kbn/es-query");
var _presentationContainers = require("@kbn/presentation-containers");
var _controlsConstants = require("@kbn/controls-constants");
var _types = require("../../../../common/options_list/types");
var _options_list = require("../../../../common/options_list");
var _data_control_manager = require("../data_control_manager");
var _options_list_control = require("./components/options_list_control");
var _options_list_editor_options = require("./components/options_list_editor_options");
var _constants = require("./constants");
var _fetch_and_validate = require("./fetch_and_validate");
var _options_list_context_provider = require("./options_list_context_provider");
var _selections_manager = require("./selections_manager");
var _options_list_strings = require("./options_list_strings");
var _temporay_state_manager = require("./temporay_state_manager");
var _editor_state_manager = require("./editor_state_manager");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/controls/public/controls/data_controls/options_list_control/get_options_list_control_factory.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getOptionsListControlFactory = () => {
  return {
    type: _controlsConstants.OPTIONS_LIST_CONTROL,
    order: 3,
    // should always be first, since this is the most popular control
    getIconType: () => 'editorChecklist',
    getDisplayName: _options_list_strings.OptionsListStrings.control.getDisplayName,
    isFieldCompatible: field => {
      return !field.spec.scripted && field.aggregatable && ['string', 'boolean', 'ip', 'date', 'number'].includes(field.type);
    },
    CustomOptionsComponent: _options_list_editor_options.OptionsListEditorOptions,
    buildControl: async ({
      initialState,
      finalizeApi,
      uuid,
      controlGroupApi
    }) => {
      var _initialState$sort, _initialState$selecte;
      if ((0, _types.isOptionsListESQLControlState)(initialState)) {
        throw new Error('ES|QL control state handling not yet implemented');
      }

      /** Serializable state - i.e. the state that is saved with the control */
      const editorStateManager = (0, _editor_state_manager.initializeEditorStateManager)(initialState);
      const sort$ = new _rxjs.BehaviorSubject((_initialState$sort = initialState.sort) !== null && _initialState$sort !== void 0 ? _initialState$sort : _constants.OPTIONS_LIST_DEFAULT_SORT);
      const placeholder = initialState.placeholder;
      const hideActionBar = initialState.hideActionBar;
      const hideExclude = initialState.hideExclude;
      const hideExists = initialState.hideExists;
      const hideSort = initialState.hideSort;
      const temporaryStateManager = (0, _temporay_state_manager.initializeTemporayStateManager)();
      const dataControlManager = (0, _data_control_manager.initializeDataControlManager)(uuid, _controlsConstants.OPTIONS_LIST_CONTROL, initialState, editorStateManager.getLatestState, editorStateManager.reinitializeState, controlGroupApi);
      const selectionsManager = (0, _selections_manager.initializeSelectionsManager)(initialState);
      const selectionsSubscription = selectionsManager.anyStateChange$.subscribe(dataControlManager.internalApi.onSelectionChange);

      /** Handle loading state; since suggestion fetching and validation are tied, only need one loading subject */
      const loadingSuggestions$ = new _rxjs.BehaviorSubject(false);
      const dataLoadingSubscription = (0, _rxjs.combineLatest)([loadingSuggestions$, dataControlManager.api.dataLoading$]).pipe((0, _rxjs.debounceTime)(100),
      // debounce set loading so that it doesn't flash as the user types
      (0, _rxjs.map)(values => values.some(value => value))).subscribe(isLoading => {
        temporaryStateManager.api.setDataLoading(isLoading);
      });

      /** Debounce the search string changes to reduce the number of fetch requests */
      const debouncedSearchString = temporaryStateManager.api.searchString$.pipe((0, _rxjs.debounceTime)(100));

      /** Validate the search string as the user types */
      const validSearchStringSubscription = (0, _rxjs.combineLatest)([debouncedSearchString, dataControlManager.api.field$, editorStateManager.api.searchTechnique$]).subscribe(([newSearchString, field, searchTechnique]) => {
        temporaryStateManager.api.setSearchStringValid((0, _options_list.isValidSearch)({
          searchString: newSearchString,
          fieldType: field === null || field === void 0 ? void 0 : field.type,
          searchTechnique
        }));
      });

      /** Clear state when the field changes */
      const fieldChangedSubscription = (0, _rxjs.combineLatest)([dataControlManager.api.fieldName$, dataControlManager.api.dataViewId$]).pipe((0, _rxjs.skip)(1) // skip first, since this represents initialization
      ).subscribe(() => {
        temporaryStateManager.api.setSearchString('');
        selectionsManager.api.setSelectedOptions(undefined);
        selectionsManager.api.setExistsSelected(false);
        selectionsManager.api.setExclude(false);
        temporaryStateManager.api.setRequestSize(_constants.MIN_OPTIONS_LIST_REQUEST_SIZE);
        sort$.next(_constants.OPTIONS_LIST_DEFAULT_SORT);
      });

      /** Fetch the suggestions and perform validation */
      const suggestionLoadError$ = new _rxjs.BehaviorSubject(undefined);
      const loadMoreSubject = new _rxjs.Subject();
      const fetchSubscription = (0, _fetch_and_validate.fetchAndValidate$)({
        api: {
          ...dataControlManager.api,
          loadMoreSubject,
          loadingSuggestions$,
          debouncedSearchString,
          parentApi: controlGroupApi
        },
        requestSize$: temporaryStateManager.api.requestSize$,
        runPastTimeout$: editorStateManager.api.runPastTimeout$,
        selectedOptions$: selectionsManager.api.selectedOptions$,
        searchTechnique$: editorStateManager.api.searchTechnique$,
        sort$,
        controlFetch$: onReload => controlGroupApi.controlFetch$(uuid, onReload)
      }).subscribe(result => {
        var _successResponse$tota, _successResponse$inva;
        // if there was an error during fetch, set suggestion load error and return early
        if (Object.hasOwn(result, 'error')) {
          suggestionLoadError$.next(result.error);
          return;
        } else if (suggestionLoadError$.getValue()) {
          // otherwise,  if there was a previous error, clear it
          suggestionLoadError$.next(undefined);
        }

        // fetch was successful so set all attributes from result
        const successResponse = result;
        temporaryStateManager.api.setAvailableOptions(successResponse.suggestions);
        temporaryStateManager.api.setTotalCardinality((_successResponse$tota = successResponse.totalCardinality) !== null && _successResponse$tota !== void 0 ? _successResponse$tota : 0);
        temporaryStateManager.api.setInvalidSelections(new Set((_successResponse$inva = successResponse.invalidSelections) !== null && _successResponse$inva !== void 0 ? _successResponse$inva : []));

        // reset the request size back to the minimum (if it's not already)
        if (temporaryStateManager.api.requestSize$.getValue() !== _constants.MIN_OPTIONS_LIST_REQUEST_SIZE) {
          temporaryStateManager.api.setRequestSize(_constants.MIN_OPTIONS_LIST_REQUEST_SIZE);
        }
      });

      /** Remove all other selections if this control becomes a single select */
      const singleSelectSubscription = editorStateManager.api.singleSelect$.pipe((0, _rxjs.filter)(singleSelect => Boolean(singleSelect))).subscribe(() => {
        var _selectionsManager$ap;
        const currentSelections = (_selectionsManager$ap = selectionsManager.api.selectedOptions$.getValue()) !== null && _selectionsManager$ap !== void 0 ? _selectionsManager$ap : [];
        if (currentSelections.length > 1) selectionsManager.api.setSelectedOptions([currentSelections[0]]);
      });
      const hasSelections$ = new _rxjs.BehaviorSubject(Boolean(((_initialState$selecte = initialState.selectedOptions) === null || _initialState$selecte === void 0 ? void 0 : _initialState$selecte.length) || initialState.existsSelected));
      const hasSelectionsSubscription = (0, _rxjs.combineLatest)([selectionsManager.api.selectedOptions$, selectionsManager.api.existsSelected$]).pipe((0, _rxjs.map)(([selectedOptions, existsSelected]) => {
        return Boolean((selectedOptions === null || selectedOptions === void 0 ? void 0 : selectedOptions.length) || existsSelected);
      }), (0, _rxjs.distinctUntilChanged)()).subscribe(hasSelections => {
        hasSelections$.next(hasSelections);
      });
      /** Output filters when selections change */
      const outputFilterSubscription = (0, _rxjs.combineLatest)([dataControlManager.api.dataViews$, dataControlManager.api.fieldName$, selectionsManager.api.selectedOptions$, selectionsManager.api.existsSelected$, selectionsManager.api.exclude$]).pipe((0, _rxjs.debounceTime)(0)).subscribe(([dataViews, fieldName, selectedOptions, existsSelected, exclude]) => {
        const dataView = dataViews === null || dataViews === void 0 ? void 0 : dataViews[0];
        const field = dataView && fieldName ? dataView.getFieldByName(fieldName) : undefined;
        let newFilter;
        if (!dataView || !field) return;
        if (existsSelected) {
          newFilter = (0, _esQuery.buildExistsFilter)(field, dataView);
        } else if (selectedOptions && selectedOptions.length > 0) {
          newFilter = selectedOptions.length === 1 ? (0, _esQuery.buildPhraseFilter)(field, selectedOptions[0], dataView) : (0, _esQuery.buildPhrasesFilter)(field, selectedOptions, dataView);
        }
        if (newFilter) {
          newFilter.meta.key = field === null || field === void 0 ? void 0 : field.name;
          if (exclude) newFilter.meta.negate = true;
        }
        dataControlManager.internalApi.setOutputFilter(newFilter);
      });
      function serializeState() {
        return {
          rawState: {
            ...dataControlManager.getLatestState(),
            ...selectionsManager.getLatestState(),
            ...editorStateManager.getLatestState(),
            sort: sort$.getValue(),
            // serialize state that cannot be changed to keep it consistent
            placeholder,
            hideActionBar,
            hideExclude,
            hideExists,
            hideSort
          },
          references: dataControlManager.internalApi.extractReferences('optionsListDataView')
        };
      }
      const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
        uuid,
        parentApi: controlGroupApi,
        serializeState,
        anyStateChange$: (0, _rxjs.merge)(dataControlManager.anyStateChange$, selectionsManager.anyStateChange$, editorStateManager.anyStateChange$, sort$).pipe((0, _rxjs.map)(() => undefined)),
        getComparators: () => {
          return {
            ..._data_control_manager.defaultDataControlComparators,
            ..._selections_manager.selectionComparators,
            ..._editor_state_manager.editorComparators,
            sort: 'deepEquality',
            // This state cannot currently be changed after the control is created
            placeholder: 'skip',
            hideActionBar: 'skip',
            hideExclude: 'skip',
            hideExists: 'skip',
            hideSort: 'skip'
          };
        },
        defaultState: {
          searchTechnique: _constants.DEFAULT_SEARCH_TECHNIQUE,
          sort: _constants.OPTIONS_LIST_DEFAULT_SORT,
          exclude: false,
          existsSelected: false
        },
        onReset: lastSaved => {
          var _lastSaved$rawState$s;
          if ((0, _types.isOptionsListESQLControlState)(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState)) {
            throw new Error('ES|QL control state handling not yet implemented');
          }
          dataControlManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          selectionsManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          editorStateManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          sort$.next((_lastSaved$rawState$s = lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState.sort) !== null && _lastSaved$rawState$s !== void 0 ? _lastSaved$rawState$s : _constants.OPTIONS_LIST_DEFAULT_SORT);
        }
      });
      const blockingError$ = new _rxjs.BehaviorSubject(undefined);
      const errorsSubscription = (0, _rxjs.combineLatest)([dataControlManager.api.blockingError$, suggestionLoadError$]).pipe((0, _rxjs.map)(([controlError, suggestionError]) => {
        return controlError !== null && controlError !== void 0 ? controlError : suggestionError;
      })).subscribe(error => blockingError$.next(error));
      const api = finalizeApi({
        ...unsavedChangesApi,
        ...dataControlManager.api,
        blockingError$,
        dataLoading$: temporaryStateManager.api.dataLoading$,
        getTypeDisplayName: _options_list_strings.OptionsListStrings.control.getDisplayName,
        serializeState,
        clearSelections: () => {
          var _selectionsManager$ap2;
          if ((_selectionsManager$ap2 = selectionsManager.api.selectedOptions$.getValue()) !== null && _selectionsManager$ap2 !== void 0 && _selectionsManager$ap2.length) selectionsManager.api.setSelectedOptions([]);
          if (selectionsManager.api.existsSelected$.getValue()) selectionsManager.api.setExistsSelected(false);
          if (temporaryStateManager.api.invalidSelections$.getValue().size) temporaryStateManager.api.setInvalidSelections(new Set([]));
        },
        hasSelections$: hasSelections$,
        setSelectedOptions: selectionsManager.api.setSelectedOptions
      });
      const componentApi = {
        ...api,
        ...dataControlManager.api,
        ...editorStateManager.api,
        ...selectionsManager.api,
        ...temporaryStateManager.api,
        loadMoreSubject,
        deselectOption: key => {
          var _selectionsManager$ap3, _selectionsManager$ap4;
          const field = api.field$.getValue();
          if (key == null || !field) {
            api.setBlockingError(new Error(_options_list_strings.OptionsListStrings.control.getInvalidSelectionMessage()));
            return;
          }
          const keyAsType = (0, _options_list.getSelectionAsFieldType)(field, key);

          // delete from selections
          const selectedOptions = (_selectionsManager$ap3 = selectionsManager.api.selectedOptions$.getValue()) !== null && _selectionsManager$ap3 !== void 0 ? _selectionsManager$ap3 : [];
          const itemIndex = ((_selectionsManager$ap4 = selectionsManager.api.selectedOptions$.getValue()) !== null && _selectionsManager$ap4 !== void 0 ? _selectionsManager$ap4 : []).indexOf(keyAsType);
          if (itemIndex !== -1) {
            const newSelections = [...selectedOptions];
            newSelections.splice(itemIndex, 1);
            selectionsManager.api.setSelectedOptions(newSelections);
          }
          // delete from invalid selections
          const currentInvalid = temporaryStateManager.api.invalidSelections$.getValue();
          if (currentInvalid.has(keyAsType)) {
            currentInvalid.delete(keyAsType);
            temporaryStateManager.api.setInvalidSelections(new Set(currentInvalid));
          }
        },
        makeSelection: (key, showOnlySelected) => {
          var _selectionsManager$ap5;
          const field = api.field$.getValue();
          if (key == null || !field) {
            api.setBlockingError(new Error(_options_list_strings.OptionsListStrings.control.getInvalidSelectionMessage()));
            return;
          }
          const existsSelected = Boolean(selectionsManager.api.existsSelected$.getValue());
          const selectedOptions = (_selectionsManager$ap5 = selectionsManager.api.selectedOptions$.getValue()) !== null && _selectionsManager$ap5 !== void 0 ? _selectionsManager$ap5 : [];
          const singleSelect = editorStateManager.api.singleSelect$.getValue();

          // the order of these checks matters, so be careful if rearranging them
          const keyAsType = (0, _options_list.getSelectionAsFieldType)(field, key);
          if (key === 'exists-option') {
            // if selecting exists, then deselect everything else
            selectionsManager.api.setExistsSelected(!existsSelected);
            if (!existsSelected) {
              selectionsManager.api.setSelectedOptions([]);
              temporaryStateManager.api.setInvalidSelections(new Set([]));
            }
          } else if (showOnlySelected || selectedOptions.includes(keyAsType)) {
            componentApi.deselectOption(key);
          } else if (singleSelect) {
            // replace selection
            selectionsManager.api.setSelectedOptions([keyAsType]);
            if (existsSelected) selectionsManager.api.setExistsSelected(false);
          } else {
            // select option
            if (existsSelected) selectionsManager.api.setExistsSelected(false);
            selectionsManager.api.setSelectedOptions(selectedOptions ? [...selectedOptions, keyAsType] : [keyAsType]);
          }
        },
        sort$,
        setSort: sort => {
          sort$.next(sort);
        },
        selectAll: keys => {
          var _selectionsManager$ap6;
          const field = api.field$.getValue();
          if (keys.length < 1 || !field) {
            api.setBlockingError(new Error(_options_list_strings.OptionsListStrings.control.getInvalidSelectionMessage()));
            return;
          }
          const selectedOptions = (_selectionsManager$ap6 = selectionsManager.api.selectedOptions$.getValue()) !== null && _selectionsManager$ap6 !== void 0 ? _selectionsManager$ap6 : [];
          const newSelections = keys.filter(key => !selectedOptions.includes(key));
          selectionsManager.api.setSelectedOptions([...selectedOptions, ...newSelections]);
        },
        deselectAll: keys => {
          var _selectionsManager$ap7;
          const field = api.field$.getValue();
          if (keys.length < 1 || !field) {
            api.setBlockingError(new Error(_options_list_strings.OptionsListStrings.control.getInvalidSelectionMessage()));
            return;
          }
          const selectedOptions = (_selectionsManager$ap7 = selectionsManager.api.selectedOptions$.getValue()) !== null && _selectionsManager$ap7 !== void 0 ? _selectionsManager$ap7 : [];
          const remainingSelections = selectedOptions.filter(option => !keys.includes(option));
          selectionsManager.api.setSelectedOptions(remainingSelections);
        }
      };
      if (selectionsManager.api.hasInitialSelections) {
        await dataControlManager.api.untilFiltersReady();
      }
      return {
        api,
        Component: ({
          className: controlPanelClassName
        }) => {
          (0, _react.useEffect)(() => {
            return () => {
              // on unmount, clean up all subscriptions
              dataLoadingSubscription.unsubscribe();
              fetchSubscription.unsubscribe();
              fieldChangedSubscription.unsubscribe();
              outputFilterSubscription.unsubscribe();
              singleSelectSubscription.unsubscribe();
              validSearchStringSubscription.unsubscribe();
              hasSelectionsSubscription.unsubscribe();
              selectionsSubscription.unsubscribe();
              errorsSubscription.unsubscribe();
            };
          }, []);
          return /*#__PURE__*/_react.default.createElement(_options_list_context_provider.OptionsListControlContext.Provider, {
            value: {
              componentApi,
              displaySettings: {
                placeholder,
                hideActionBar,
                hideExclude,
                hideExists,
                hideSort
              }
            },
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 473,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(_options_list_control.OptionsListControl, {
            controlPanelClassName: controlPanelClassName,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 479,
              columnNumber: 15
            }
          }));
        }
      };
    }
  };
};
exports.getOptionsListControlFactory = getOptionsListControlFactory;