"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DraggableBodyRow = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _body_row = require("./body_row");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/shared/tables/reorderable_table/draggable_body_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DraggableBodyRow = ({
  additionalProps,
  ariaRowindex,
  columns,
  disableDragging = false,
  errors,
  item,
  rowIdentifier,
  rowIndex
}) => {
  const draggableId = `draggable_row_${rowIndex}`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, (0, _extends2.default)({
    index: rowIndex,
    draggableId: draggableId,
    isDragDisabled: disableDragging,
    customDragHandle: !disableDragging,
    hasInteractiveChildren: true,
    usePortal: true
  }, additionalProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }), provided => /*#__PURE__*/_react.default.createElement(_body_row.BodyRow, {
    columns: columns,
    item: item,
    additionalProps: additionalProps,
    leftAction: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 15
      }
    }, disableDragging ? /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: '16px'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 19
      }
    }) : /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, provided.dragHandleProps, {
      "aria-label": _i18n.i18n.translate('xpack.contentConnectors.draggableBodyRow.dragHandleLabel', {
        defaultMessage: 'Drag handle'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 19
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "grab",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 21
      }
    })))),
    rowIdentifier: rowIdentifier,
    errors: errors,
    ariaRowindex: ariaRowindex,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }));
};
exports.DraggableBodyRow = DraggableBodyRow;