"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorOverviewPanels = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
var _public = require("@kbn/kibana-react-plugin/public");
var _routes = require("../../routes");
var _indices = require("../../../utils/indices");
var _index_view_logic = require("../index_view_logic");
var _encode_path_params = require("../../shared/encode_path_params");
var _constants = require("../../../../common/constants");
var _react_router_helpers = require("../../shared/react_router_helpers");
var _ingestion_status_helpers = require("../../../utils/ingestion_status_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/search_index/connector/connector_overview_panels.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StatusPanel = ({
  ingestionStatus
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  color: (0, _ingestion_status_helpers.ingestionStatusToColor)(ingestionStatus),
  hasShadow: false,
  paddingSize: "l",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 32,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
  titleSize: "s",
  description: _i18n.i18n.translate('xpack.contentConnectors.connector.ingestionStatus.title', {
    defaultMessage: 'Ingestion status'
  }),
  title: (0, _ingestion_status_helpers.ingestionStatusToText)(ingestionStatus),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 33,
    columnNumber: 5
  }
}));
const ConnectorOverviewPanels = () => {
  const {
    services: {
      http
    }
  } = (0, _public.useKibana)();
  const {
    ingestionStatus,
    index
  } = (0, _kea.useValues)((0, _index_view_logic.IndexViewLogic)({
    http
  }));
  return (0, _indices.isConnectorIndex)(index) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "primary",
    hasShadow: false,
    paddingSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "entSearchContent-indexOverview-totalStats-documentCount",
    titleSize: "s",
    description: _i18n.i18n.translate('xpack.contentConnectors.content.searchIndex.totalStats.documentCountCardLabel', {
      defaultMessage: 'Document count'
    }),
    title: index.count,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    "data-test-subj": "entSearchContent-indexOverview-connectorStats-ingestionStatus",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, ingestionStatus === _searchConnectors.IngestionStatus.INCOMPLETE ? /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
    to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
      indexName: index.name,
      tabId: _constants.SearchIndexTabId.CONFIGURATION
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(StatusPanel, {
    ingestionStatus: ingestionStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  })) : /*#__PURE__*/_react.default.createElement(StatusPanel, {
    ingestionStatus: ingestionStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
};
exports.ConnectorOverviewPanels = ConnectorOverviewPanels;