"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorDescriptionPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _app_context = require("../../../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/connectors/create_connector/components/connector_description_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const nativePopoverPanels = [{
  description: _i18n.i18n.translate('xpack.contentConnectors.connectorDescriptionPopover.connectorDescriptionBadge.native.chooseADataSourceLabel', {
    defaultMessage: 'Choose a data source you would like to sync'
  }),
  icons: [/*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "documents",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 13
    }
  })],
  id: 'native-choose-source'
}, {
  description: _i18n.i18n.translate('xpack.contentConnectors.connectorDescriptionPopover.connectorDescriptionBadge.native.configureConnectorLabel', {
    defaultMessage: 'Configure your connector using our Kibana UI'
  }),
  icons: [/*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "plugs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "logoElastic",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 48
    }
  })],
  id: 'native-configure-connector'
}];
const connectorClientPopoverPanels = [{
  description: _i18n.i18n.translate('xpack.contentConnectors.connectorDescriptionPopover.connectorDescriptionBadge.client.chooseADataSourceLabel', {
    defaultMessage: 'Choose a data source you would like to sync'
  }),
  icons: [/*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "documents",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 13
    }
  })],
  id: 'client-choose-source'
}, {
  description: _i18n.i18n.translate('xpack.contentConnectors.connectorDescriptionPopover.connectorDescriptionBadge.client.configureConnectorLabel', {
    defaultMessage: 'Deploy connector code on your own infrastructure by running from source or using Docker'
  }),
  icons: [/*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "plugs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "sortRight",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "launch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  })],
  id: 'client-deploy'
}, {
  description: _i18n.i18n.translate('xpack.contentConnectors.connectorDescriptionPopover.connectorDescriptionBadge.client.enterDetailsLabel', {
    defaultMessage: 'Enter access and connection details for your data source'
  }),
  icons: [/*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "documents",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "sortRight",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "plugs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "sortRight",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "logoElastic",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  })],
  id: 'client-configure-connector'
}];
const ConnectorDescriptionPopover = ({
  isNative,
  showIsOnlySelfManaged,
  isElasticManagedDiscontinued
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const panels = isNative ? nativePopoverPanels : connectorClientPopoverPanels;
  const {
    isAgentlessEnabled
  } = (0, _app_context.useAppContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "upCenter",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.contentConnectors.createConnector.info', {
        defaultMessage: 'More information'
      }),
      "data-test-subj": "enterpriseSearchConnectorDescriptionPopoverButton",
      iconType: "info",
      onClick: () => setIsPopoverOpen(!isPopoverOpen),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 9
      }
    }),
    isOpen: isPopoverOpen,
    closePopover: () => {
      setIsPopoverOpen(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: (0, _react2.css)`
          max-width: 700px;
        `,
    hasBorder: false,
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }, (isNative && !isAgentlessEnabled || showIsOnlySelfManaged) && !isElasticManagedDiscontinued && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: showIsOnlySelfManaged ? _i18n.i18n.translate('xpack.contentConnectors.createConnector.connectorDescriptionBadge.isOnlySelfManagedAvailableTitle', {
      defaultMessage: 'This connector is not available as an Elastic-managed Connector'
    }) : _i18n.i18n.translate('xpack.contentConnectors.createConnector.connectorDescriptionBadge.isRunningLocallyTitle', {
      defaultMessage: 'Elastic managed connectors are only available in Elastic Cloud'
    }),
    size: "s",
    iconType: "warning",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 15
    }
  })), isElasticManagedDiscontinued && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.contentConnectors.createConnector.connectorDescriptionBadge.elasticManagedDiscontinuedTitle', {
      defaultMessage: 'Elastic managed Connector are no longer supported'
    }),
    size: "s",
    iconType: "warning",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 13
    }
  })), (isNative && isAgentlessEnabled || !isNative) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 11
    }
  }, panels.map(panel => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: panel.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      alignItems: "center",
      gutterSize: "s",
      style: {
        maxWidth: 200
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 23
      }
    }, panel.icons.map((icon, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: index,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 27
      }
    }, icon)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      grow: false,
      textAlign: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 25
      }
    }, panel.description)))));
  })), isNative && !isAgentlessEnabled && !isElasticManagedDiscontinued && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.createConnector.connectorDescriptionBadge.learnMore', {
    defaultMessage: 'Explore Elastic Cloud with your 14-day free trial'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    textAlign: "center",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.createConnector.connectorDescriptionBadge.learnMore', {
    defaultMessage: 'Take advantage of Elastic managed connectors and generative AI capabilities to address search challenges across your organization in real time, at scale.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterprisecontentConnectors.tartFreeTrialButton",
    href: "https://cloud.elastic.co/registration?onboarding_token=connectors",
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.createConnector.startTrialButtonLabel', {
    defaultMessage: 'Start free trial'
  })))))));
};
exports.ConnectorDescriptionPopover = ConnectorDescriptionPopover;