"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHighlightedLinesClassName = exports.useActionStyles = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useActionStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    actions: (0, _react.css)`
      position: absolute;
      z-index: ${euiTheme.levels.header};
      top: 0;
      // Adjust for possible scrollbars
      right: ${euiTheme.size.base};
      height: ${euiTheme.size.xl};
      background-color: ${euiTheme.colors.emptyShade};
      border-radius: ${euiTheme.size.xs};
      box-shadow: 0 0 calc(${euiTheme.size.xs} * 0.5) calc(${euiTheme.size.xs} * 0.5)
        ${euiTheme.colors.lightShade};
      padding-top: calc(${euiTheme.size.base} * 0.1);
      overflow-y: auto;
    `
  };
};
exports.useActionStyles = useActionStyles;
const useHighlightedLinesClassName = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return (0, _css.css)`
    position: relative;
    padding: ${euiTheme.size.xs}; /* Adds space between border and text */

    &::before {
      content: '';
      position: absolute;
      top: 0;
      bottom: calc(-${euiTheme.size.base} * 0.1);
      left: calc(-${euiTheme.size.base} * 0.35);
      right: 0;
      background: ${(0, _eui.transparentize)(euiTheme.colors.primary, 0.05)};
      border: ${euiTheme.border.thin};
      border-color: ${euiTheme.colors.primary};
      pointer-events: none; /* Ensures the pseudo-element doesn't block interactions */
    }
  `;
};
exports.useHighlightedLinesClassName = useHighlightedLinesClassName;