"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUB_ACTION = exports.CONNECTOR_NAME = exports.CONNECTOR_ID = exports.API_MAX_RESULTS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const CONNECTOR_ID = exports.CONNECTOR_ID = '.sentinelone';
const CONNECTOR_NAME = exports.CONNECTOR_NAME = _i18n.i18n.translate('connectors.sentinelone.title', {
  defaultMessage: 'Sentinel One'
});
const API_MAX_RESULTS = exports.API_MAX_RESULTS = 1000;
let SUB_ACTION = exports.SUB_ACTION = /*#__PURE__*/function (SUB_ACTION) {
  SUB_ACTION["EXECUTE_SCRIPT"] = "executeScript";
  SUB_ACTION["GET_AGENTS"] = "getAgents";
  SUB_ACTION["ISOLATE_HOST"] = "isolateHost";
  SUB_ACTION["RELEASE_HOST"] = "releaseHost";
  SUB_ACTION["GET_REMOTE_SCRIPTS"] = "getRemoteScripts";
  SUB_ACTION["GET_REMOTE_SCRIPT_STATUS"] = "getRemoteScriptStatus";
  SUB_ACTION["GET_REMOTE_SCRIPT_RESULTS"] = "getRemoteScriptResults";
  SUB_ACTION["DOWNLOAD_REMOTE_SCRIPT_RESULTS"] = "downloadRemoteScriptResults";
  SUB_ACTION["FETCH_AGENT_FILES"] = "fetchAgentFiles";
  SUB_ACTION["DOWNLOAD_AGENT_FILE"] = "downloadAgentFile";
  SUB_ACTION["GET_ACTIVITIES"] = "getActivities";
  return SUB_ACTION;
}({});