"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryMetadataSchema = exports.StreamingResponseSchema = exports.SecretsSchema = exports.RunApiLatestResponseSchema = exports.RunActionResponseSchema = exports.RunActionParamsSchema = exports.InvokeAIRawActionResponseSchema = exports.InvokeAIRawActionParamsSchema = exports.InvokeAIActionResponseSchema = exports.InvokeAIActionParamsSchema = exports.DashboardActionResponseSchema = exports.DashboardActionParamsSchema = exports.ConverseStreamActionParamsSchema = exports.ConverseActionParamsSchema = exports.ConfigSchema = exports.BedrockUsageSchema = exports.BedrockToolChoiceSchema = exports.BedrockMessageSchema = exports.BedrockClientSendResponseSchema = exports.BedrockClientSendParamsSchema = void 0;
var _zod = require("@kbn/zod");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TelemetryMetadataSchema = exports.TelemetryMetadataSchema = _zod.z.object({
  pluginId: _zod.z.string().optional(),
  aggregateBy: _zod.z.string().optional()
}).strict();

// Connector schema
const ConfigSchema = exports.ConfigSchema = _zod.z.object({
  apiUrl: _zod.z.string(),
  defaultModel: _zod.z.string().default(_constants.DEFAULT_MODEL),
  contextWindowLength: _zod.z.coerce.number().optional(),
  temperature: _zod.z.coerce.number().optional()
}).strict();
const SecretsSchema = exports.SecretsSchema = _zod.z.object({
  accessKey: _zod.z.string(),
  secret: _zod.z.string()
}).strict();
const RunActionParamsSchema = exports.RunActionParamsSchema = _zod.z.object({
  body: _zod.z.string(),
  model: _zod.z.string().optional(),
  // abort signal from client
  signal: _zod.z.any().optional(),
  timeout: _zod.z.coerce.number().optional(),
  raw: _zod.z.boolean().optional(),
  telemetryMetadata: TelemetryMetadataSchema.optional()
}).strict();
const BedrockMessageSchema = exports.BedrockMessageSchema = _zod.z.object({
  role: _zod.z.string(),
  content: _zod.z.string().optional(),
  rawContent: _zod.z.array(_zod.z.any()).optional()
}).strict().superRefine((value, ctx) => {
  if (value.content === undefined && value.rawContent === undefined) {
    ctx.addIssue({
      code: _zod.z.ZodIssueCode.custom,
      message: 'Must specify either content or rawContent'
    });
  } else if (value.content !== undefined && value.rawContent !== undefined) {
    ctx.addIssue({
      code: _zod.z.ZodIssueCode.custom,
      message: 'content and rawContent can not be used at the same time'
    });
  }
});
const BedrockToolChoiceSchema = exports.BedrockToolChoiceSchema = _zod.z.object({
  type: _zod.z.enum(['auto', 'any', 'tool']),
  name: _zod.z.string().optional()
}).strict();
const BedrockUsageSchema = exports.BedrockUsageSchema = _zod.z.object({
  input_tokens: _zod.z.coerce.number(),
  output_tokens: _zod.z.coerce.number(),
  // added with Sonnet 3.7
  cache_creation_input_tokens: _zod.z.coerce.number().optional()
}).passthrough().optional();
const InvokeAIActionParamsSchema = exports.InvokeAIActionParamsSchema = _zod.z.object({
  messages: _zod.z.array(BedrockMessageSchema),
  model: _zod.z.string().optional(),
  temperature: _zod.z.coerce.number().optional(),
  stopSequences: _zod.z.array(_zod.z.string()).optional(),
  system: _zod.z.string().optional(),
  maxTokens: _zod.z.coerce.number().optional(),
  // abort signal from client
  signal: _zod.z.any().optional(),
  timeout: _zod.z.coerce.number().optional(),
  anthropicVersion: _zod.z.string().optional(),
  tools: _zod.z.array(_zod.z.object({
    name: _zod.z.string(),
    description: _zod.z.string(),
    input_schema: _zod.z.object({}).passthrough()
  }).strict()).optional(),
  toolChoice: BedrockToolChoiceSchema.optional(),
  telemetryMetadata: TelemetryMetadataSchema.optional()
}).strict();
const InvokeAIActionResponseSchema = exports.InvokeAIActionResponseSchema = _zod.z.object({
  message: _zod.z.string(),
  usage: BedrockUsageSchema
}).strict();
const InvokeAIRawActionParamsSchema = exports.InvokeAIRawActionParamsSchema = _zod.z.object({
  messages: _zod.z.array(_zod.z.object({
    role: _zod.z.string(),
    content: _zod.z.any()
  }).strict()),
  model: _zod.z.string().optional(),
  temperature: _zod.z.coerce.number().optional(),
  stopSequences: _zod.z.array(_zod.z.string()).optional(),
  system: _zod.z.string().optional(),
  maxTokens: _zod.z.coerce.number().optional(),
  // abort signal from client
  signal: _zod.z.any().optional(),
  anthropicVersion: _zod.z.string().optional(),
  timeout: _zod.z.coerce.number().optional(),
  tools: _zod.z.array(_zod.z.object({
    name: _zod.z.string(),
    description: _zod.z.string(),
    input_schema: _zod.z.object({}).passthrough()
  }).strict()).optional(),
  toolChoice: BedrockToolChoiceSchema.optional(),
  telemetryMetadata: TelemetryMetadataSchema.optional()
}).strict();
const InvokeAIRawActionResponseSchema = exports.InvokeAIRawActionResponseSchema = _zod.z.object({}).passthrough();
const RunApiLatestResponseSchema = exports.RunApiLatestResponseSchema = _zod.z.object({
  stop_reason: _zod.z.string().optional(),
  usage: BedrockUsageSchema,
  content: _zod.z.array(_zod.z.object({
    type: _zod.z.string(),
    text: _zod.z.string().optional()
  }).passthrough())
}).passthrough();
const RunActionResponseSchema = exports.RunActionResponseSchema = _zod.z.object({
  completion: _zod.z.string(),
  stop_reason: _zod.z.string().optional(),
  usage: BedrockUsageSchema
});
const StreamingResponseSchema = exports.StreamingResponseSchema = _zod.z.any();

// Run action schema
const DashboardActionParamsSchema = exports.DashboardActionParamsSchema = _zod.z.object({
  dashboardId: _zod.z.string()
}).strict();
const DashboardActionResponseSchema = exports.DashboardActionResponseSchema = _zod.z.object({
  available: _zod.z.boolean()
}).strict();
const BedrockClientSendParamsSchema = exports.BedrockClientSendParamsSchema = _zod.z.object({
  // ConverseCommand | ConverseStreamCommand from @aws-sdk/client-bedrock-runtime
  command: _zod.z.any(),
  // Kibana related properties
  signal: _zod.z.any().optional(),
  telemetryMetadata: TelemetryMetadataSchema.optional()
}).strict();
const BedrockClientSendResponseSchema = exports.BedrockClientSendResponseSchema = _zod.z.object({}).passthrough();
const ConverseActionParamsSchema = exports.ConverseActionParamsSchema = _zod.z.object({
  // Converse API will already be validating, no need for us to strictly validate again
  messages: _zod.z.array(_zod.z.any()),
  model: _zod.z.string().optional(),
  system: _zod.z.array(_zod.z.any()).optional(),
  temperature: _zod.z.coerce.number().optional(),
  maxTokens: _zod.z.coerce.number().optional(),
  stopSequences: _zod.z.array(_zod.z.string()).optional(),
  tools: _zod.z.array(_zod.z.any()).optional(),
  toolChoice: _zod.z.any().optional(),
  // Kibana related properties
  signal: _zod.z.any().optional(),
  timeout: _zod.z.coerce.number().optional(),
  telemetryMetadata: TelemetryMetadataSchema.optional(),
  connectorUsageCollector: _zod.z.any().optional()
}).passthrough();
const ConverseStreamActionParamsSchema = exports.ConverseStreamActionParamsSchema = ConverseActionParamsSchema;