"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesTableHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _use_change_csp_rule_state = require("./use_change_csp_rule_state");
var _multi_select_filter = require("../../common/component/multi_select_filter");
var _test_subjects = require("./test_subjects");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/rules/rules_table_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RulesTableHeader = ({
  search,
  searchValue,
  isSearching,
  totalRulesCount,
  pageSize,
  onSectionChange,
  onRuleNumberChange,
  sectionSelectOptions,
  ruleNumberSelectOptions,
  selectedRules,
  setEnabledDisabledItemsFilter,
  enabledDisabledItemsFilterState,
  setSelectAllRules,
  setSelectedRules
}) => {
  const [selectedSection, setSelectedSection] = (0, _react.useState)([]);
  const [selectedRuleNumber, setSelectedRuleNumber] = (0, _react.useState)([]);
  const sectionOptions = sectionSelectOptions.map(option => ({
    key: option,
    label: option
  }));
  const ruleNumberOptions = ruleNumberSelectOptions.map(option => ({
    key: option,
    label: option
  }));
  const toggleEnabledRulesFilter = () => {
    if (enabledDisabledItemsFilterState === 'enabled') setEnabledDisabledItemsFilter('no-filter');else setEnabledDisabledItemsFilter('enabled');
  };
  const toggleDisabledRulesFilter = () => {
    if (enabledDisabledItemsFilterState === 'disabled') setEnabledDisabledItemsFilter('no-filter');else setEnabledDisabledItemsFilter('disabled');
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(SearchField, {
    isSearching: isSearching,
    searchValue: searchValue,
    search: search,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_subjects.RULES_TABLE_HEADER_TEST_SUBJ.RULES_TABLE_HEADER_MULTI_SELECT,
    css: (0, _react2.css)`
                min-width: 160px;
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_multi_select_filter.MultiSelectFilter, {
    buttonLabel: _i18n.i18n.translate('xpack.csp.rules.rulesTableHeader.sectionSelectPlaceholder', {
      defaultMessage: 'CIS Section'
    }),
    id: 'cis-section-multi-select-filter',
    onChange: section => {
      setSelectedSection([...(section === null || section === void 0 ? void 0 : section.selectedOptionKeys)]);
      onSectionChange(section !== null && section !== void 0 && section.selectedOptionKeys ? section === null || section === void 0 ? void 0 : section.selectedOptionKeys : undefined);
    },
    options: sectionOptions,
    selectedOptionKeys: selectedSection,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
                min-width: 160px;
              `,
    "data-test-subj": _test_subjects.RULES_TABLE_HEADER_TEST_SUBJ.RULES_TABLE_HEADER_RULE_NUMBER_SELECT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_multi_select_filter.MultiSelectFilter, {
    buttonLabel: _i18n.i18n.translate('xpack.csp.rules.rulesTableHeader.ruleNumberSelectPlaceholder', {
      defaultMessage: 'Rule Number'
    }),
    id: 'rule-number-multi-select-filter',
    onChange: ruleNumber => {
      setSelectedRuleNumber([...(ruleNumber === null || ruleNumber === void 0 ? void 0 : ruleNumber.selectedOptionKeys)]);
      onRuleNumberChange(ruleNumber !== null && ruleNumber !== void 0 && ruleNumber.selectedOptionKeys ? ruleNumber === null || ruleNumber === void 0 ? void 0 : ruleNumber.selectedOptionKeys : undefined);
    },
    options: ruleNumberOptions,
    selectedOptionKeys: selectedRuleNumber,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
                min-width: 220px;
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    withNext: true,
    isToggle: true,
    isSelected: enabledDisabledItemsFilterState === 'enabled',
    hasActiveFilters: enabledDisabledItemsFilterState === 'enabled',
    onClick: toggleEnabledRulesFilter,
    "data-test-subj": _test_subjects.RULES_TABLE_HEADER_TEST_SUBJ.RULES_ENABLED_FILTER,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.rules.rulesTable.enabledRuleFilterButton",
    defaultMessage: "Enabled rules",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    isToggle: true,
    isSelected: enabledDisabledItemsFilterState === 'enabled',
    hasActiveFilters: enabledDisabledItemsFilterState === 'disabled',
    onClick: toggleDisabledRulesFilter,
    "data-test-subj": _test_subjects.RULES_TABLE_HEADER_TEST_SUBJ.RULES_DISABLED_FILTER,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.rules.rulesTable.disabledRuleFilterButton",
    defaultMessage: "Disabled rules",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 19
    }
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(CurrentPageOfTotal, {
    pageSize: pageSize,
    total: totalRulesCount,
    selectedRules: selectedRules,
    setSelectAllRules: setSelectAllRules,
    setSelectedRules: setSelectedRules,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 9
    }
  })));
};
exports.RulesTableHeader = RulesTableHeader;
const SEARCH_DEBOUNCE_MS = 300;
const SearchField = ({
  search,
  isSearching,
  searchValue
}) => {
  const [localValue, setLocalValue] = (0, _react.useState)(searchValue);
  (0, _useDebounce.default)(() => search(localValue), SEARCH_DEBOUNCE_MS, [localValue]);
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: {
      alignItems: 'flex-end'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": _test_subjects.RULES_TABLE_HEADER_TEST_SUBJ.RULES_TABLE_HEADER_SEARCH_INPUT,
    isLoading: isSearching,
    placeholder: _i18n.i18n.translate('xpack.csp.rules.rulesTable.searchPlaceholder', {
      defaultMessage: 'Search by Rule Name'
    }),
    value: localValue,
    onChange: e => setLocalValue(e.target.value),
    css: {
      minWidth: 150
    },
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 9
    }
  })));
};
const CurrentPageOfTotal = ({
  pageSize,
  total,
  selectedRules,
  setSelectAllRules,
  setSelectedRules
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onPopoverClick = () => {
    setIsPopoverOpen(e => !e);
  };
  const {
    mutate: mutateRulesStates
  } = (0, _use_change_csp_rule_state.useChangeCspRuleState)();
  const changeCspRuleState = state => {
    const bulkSelectedRules = selectedRules.map(e => ({
      benchmark_id: e === null || e === void 0 ? void 0 : e.metadata.benchmark.id,
      benchmark_version: e === null || e === void 0 ? void 0 : e.metadata.benchmark.version,
      rule_number: e === null || e === void 0 ? void 0 : e.metadata.benchmark.rule_number,
      rule_id: e === null || e === void 0 ? void 0 : e.metadata.id
    }));
    // Only do the API Call IF there are no undefined value for rule number in the selected rules
    if (!bulkSelectedRules.some(rule => rule.rule_number === undefined)) {
      mutateRulesStates({
        newState: state,
        ruleIds: bulkSelectedRules
      });
      setIsPopoverOpen(false);
    }
    setSelectedRules([]);
  };
  const changeCspRuleStateMute = () => {
    changeCspRuleState('mute');
  };
  const changeCspRuleStateUnmute = () => {
    changeCspRuleState('unmute');
  };
  const areAllSelectedRulesMuted = selectedRules.every(rule => (rule === null || rule === void 0 ? void 0 : rule.state) === 'muted');
  const areAllSelectedRulesUnmuted = selectedRules.every(rule => (rule === null || rule === void 0 ? void 0 : rule.state) === 'unmuted');
  const popoverButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onPopoverClick,
    size: "xs",
    iconType: "arrowDown",
    iconSide: "right",
    "data-test-subj": _test_subjects.RULES_TABLE_HEADER_TEST_SUBJ.BULK_ACTION_BUTTON,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 5
    }
  }, "Bulk actions");
  const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    disabled: selectedRules.length === 0 || areAllSelectedRulesUnmuted,
    onClick: changeCspRuleStateUnmute,
    "data-test-subj": _test_subjects.RULES_TABLE_HEADER_TEST_SUBJ.BULK_ACTION_OPTION_ENABLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    key: "disabled",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.rules.rulesTable.optionEnable",
    defaultMessage: "Enable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 9
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    disabled: selectedRules.length === 0 || areAllSelectedRulesMuted,
    onClick: changeCspRuleStateMute,
    "data-test-subj": _test_subjects.RULES_TABLE_HEADER_TEST_SUBJ.BULK_ACTION_OPTION_DISABLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.rules.rulesTable.optionDisable",
    defaultMessage: "Disable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 9
    }
  })))];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: 'center',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": _test_subjects.RULES_TABLE_HEADER_TEST_SUBJ.RULES_TABLE_HEADER_RULE_SHOWING_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    textAlign: "left",
    color: "subdued",
    css: {
      marginLeft: '8px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.rules.rulesTable.showingPageOfTotalLabel",
    defaultMessage: "Showing {pageSize} of {total, plural, one {# rule} other {# rules}} {pipe} Selected {selectedRulesAmount, plural, one {# rule} other {# rules}}",
    values: {
      pageSize,
      total,
      selectedRulesAmount: selectedRules.length || 0,
      pipe: '\u2000|\u2000'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 9
    }
  }, selectedRules.length !== total ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: setSelectAllRules,
    size: "xs",
    iconType: "pagesSelect",
    "data-test-subj": _test_subjects.RULES_TABLE_HEADER_TEST_SUBJ.SELECT_ALL_RULES,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.rules.rulesTable.selectAllRulesOption",
    defaultMessage: "Select All {total, plural, one {# rule} other {# rules}}",
    values: {
      total
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 15
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => setSelectedRules([]),
    size: "xs",
    iconType: "cross",
    "data-test-subj": _test_subjects.RULES_TABLE_HEADER_TEST_SUBJ.CLEAR_ALL_RULES_SELECTION,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.rules.rulesTable.clearSelectionOption",
    defaultMessage: "Clear selection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 347,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 354,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: popoverButton,
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    anchorPosition: "downLeft",
    panelPaddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    css: {
      minWidth: 240
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    textAlign: "left",
    color: "subdued",
    css: {
      marginLeft: '8px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.rules.rulesTable.bulkActionsOptionTitle",
    defaultMessage: "Options",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: items,
    css: (0, _react2.css)`
                mid-width: 540px;
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 13
    }
  })))));
};