"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleFlyout = exports.RULES_FLYOUT_SWITCH_BUTTON = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _create_detection_rule_from_benchmark = require("@kbn/cloud-security-posture/src/utils/create_detection_rule_from_benchmark");
var _rule_tab = require("../configurations/findings_flyout/rule_tab");
var _overview_tab = require("../configurations/findings_flyout/overview_tab");
var TEST_SUBJECTS = _interopRequireWildcard(require("./test_subjects"));
var _use_change_csp_rule_state = require("./use_change_csp_rule_state");
var _take_action = require("../../components/take_action");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/rules/rules_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RULES_FLYOUT_SWITCH_BUTTON = exports.RULES_FLYOUT_SWITCH_BUTTON = 'rule-flyout-switch-button';
const tabs = [{
  label: _i18n.i18n.translate('xpack.csp.rules.ruleFlyout.overviewTabLabel', {
    defaultMessage: 'Overview'
  }),
  id: 'overview',
  disabled: false
}, {
  label: _i18n.i18n.translate('xpack.csp.rules.ruleFlyout.remediationTabLabel', {
    defaultMessage: 'Remediation'
  }),
  id: 'remediation',
  disabled: false
}];
const RuleFlyout = ({
  onClose,
  rule
}) => {
  const [tab, setTab] = (0, _react.useState)('overview');
  const isRuleMuted = (rule === null || rule === void 0 ? void 0 : rule.state) === 'muted';
  const {
    mutate: mutateRuleState
  } = (0, _use_change_csp_rule_state.useChangeCspRuleState)();
  const switchRuleStates = async () => {
    if (rule.metadata.benchmark.rule_number) {
      const rulesObjectRequest = {
        benchmark_id: rule.metadata.benchmark.id,
        benchmark_version: rule.metadata.benchmark.version,
        rule_number: rule.metadata.benchmark.rule_number,
        rule_id: rule.metadata.id
      };
      const nextRuleStates = isRuleMuted ? 'unmute' : 'mute';
      mutateRuleState({
        newState: nextRuleStates,
        ruleIds: [rulesObjectRequest]
      });
    }
  };
  const createMisconfigurationRuleFn = async http => await (0, _create_detection_rule_from_benchmark.createDetectionRuleFromBenchmarkRule)(http, rule.metadata);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "data-test-subj": TEST_SUBJECTS.CSP_RULES_FLYOUT_CONTAINER,
    outsideClickCloses: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }, rule.metadata.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, tabs.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: item.id,
    isSelected: tab === item.id,
    onClick: () => setTab(item.id),
    disabled: item.disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 13
    }
  }, item.label)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, tab === 'overview' && /*#__PURE__*/_react.default.createElement(RuleOverviewTab, {
    rule: rule.metadata,
    ruleData: rule,
    switchRuleStates: switchRuleStates,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }), tab === 'remediation' && /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: false,
    listItems: (0, _overview_tab.getRemediationList)(rule.metadata),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "rowReverse",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }, isRuleMuted ? /*#__PURE__*/_react.default.createElement(_take_action.TakeAction, {
    enableBenchmarkRuleFn: switchRuleStates,
    createRuleFn: createMisconfigurationRuleFn,
    isCreateDetectionRuleDisabled: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_take_action.TakeAction, {
    disableBenchmarkRuleFn: switchRuleStates,
    createRuleFn: createMisconfigurationRuleFn,
    isCreateDetectionRuleDisabled: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 15
    }
  })))));
};
exports.RuleFlyout = RuleFlyout;
const RuleOverviewTab = ({
  rule,
  ruleData,
  switchRuleStates
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 152,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 153,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
  listItems: [...ruleState(ruleData, switchRuleStates), ...(0, _rule_tab.getRuleList)(rule, ruleData.state)],
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 154,
    columnNumber: 7
  }
})));
const ruleState = (rule, switchRuleStates) => {
  const ruleStateSwitchTooltipText = _i18n.i18n.translate('xpack.csp.rules.rulesFlyout.ruleStateSwitchTooltip', {
    defaultMessage: `Disabling a rule will also disable its associated detection rules and alerts. Enabling it again does not automatically re-enable them`
  });
  return [{
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.rules.rulesFlyout.ruleStateSwitchTitle",
      defaultMessage: "Enabled",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: {
        '.euiToolTipAnchor': {
          display: 'flex' // needed to align the icon with the title
        }
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: ruleStateSwitchTooltipText,
      "aria-label": ruleStateSwitchTooltipText,
      type: "info",
      size: "m",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 13
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      className: "eui-textTruncate",
      checked: (rule === null || rule === void 0 ? void 0 : rule.state) !== 'muted',
      onChange: switchRuleStates,
      "data-test-subj": RULES_FLYOUT_SWITCH_BUTTON,
      label: " ",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 11
      }
    }))
  }];
};