"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterFieldsBySearch = exports.FieldsSelectorTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useSessionStorage = _interopRequireDefault(require("react-use/lib/useSessionStorage"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/cloud_security_data_table/fields_selector/fields_selector_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ACTION_COLUMN_WIDTH = '24px';
const defaultSorting = {
  sort: {
    field: 'name',
    direction: 'asc'
  }
};
const VIEW_LABEL = _i18n.i18n.translate('xpack.csp.dataTable.fieldsModal.viewLabel', {
  defaultMessage: 'View'
});
const VIEW_VALUE_SELECTED = _i18n.i18n.translate('xpack.csp.dataTable.fieldsModal.viewSelected', {
  defaultMessage: 'selected'
});
const VIEW_VALUE_ALL = _i18n.i18n.translate('xpack.csp.dataTable.fieldsModal.viewAll', {
  defaultMessage: 'all'
});
const filterFieldsBySearch = (fields, visibleColumns = [], searchQuery, isFilterSelectedEnabled = false) => {
  const allowedFields = fields.filter(field => field.name !== '_index' && field.visualizable).map(field => ({
    id: field.name,
    name: field.name,
    displayName: field.customLabel || ''
  }));
  const visibleFields = !isFilterSelectedEnabled ? allowedFields : allowedFields.filter(field => visibleColumns.includes(field.id));
  return !searchQuery ? visibleFields : visibleFields.filter(field => {
    const normalizedName = `${field.name} ${field.displayName}`.toLowerCase();
    const normalizedQuery = searchQuery.toLowerCase() || '';
    return normalizedName.indexOf(normalizedQuery) !== -1;
  });
};
exports.filterFieldsBySearch = filterFieldsBySearch;
const FieldsSelectorTable = ({
  title,
  dataView,
  columns,
  onAddColumn,
  onRemoveColumn
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [searchQuery, setSearchQuery] = (0, _react.useState)();
  const [isFilterSelectedEnabled, setIsFilterSelectedEnabled] = (0, _useSessionStorage.default)(_constants.SESSION_STORAGE_FIELDS_MODAL_SHOW_SELECTED, false);
  const [pagination, setPagination] = (0, _react.useState)({
    pageIndex: 0
  });
  const onTableChange = ({
    page: {
      index
    }
  }) => {
    setPagination({
      pageIndex: index
    });
  };
  const fields = (0, _react.useMemo)(() => filterFieldsBySearch(dataView.fields.getAll(), columns, searchQuery, isFilterSelectedEnabled), [dataView, columns, searchQuery, isFilterSelectedEnabled]);
  const togglePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(open => !open);
  }, []);
  const closePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const onFilterSelectedChange = (0, _react.useCallback)(enabled => {
    setIsFilterSelectedEnabled(enabled);
  }, [setIsFilterSelectedEnabled]);
  let debounceTimeoutId;
  const onQueryChange = ({
    query
  }) => {
    clearTimeout(debounceTimeoutId);
    debounceTimeoutId = setTimeout(() => {
      setSearchQuery(query === null || query === void 0 ? void 0 : query.text);
    }, 300);
  };
  const tableColumns = [{
    field: 'action',
    name: '',
    width: ACTION_COLUMN_WIDTH,
    sortable: false,
    render: (_, {
      id
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      checked: columns.includes(id),
      id: `cloud-security-fields-selector-item-${id}`,
      "data-test-subj": `cloud-security-fields-selector-item-${id}`,
      "aria-label": _i18n.i18n.translate('xpack.csp.dataTable.fieldsModal.toggleFieldColumnAriaLabel', {
        defaultMessage: 'Toggle {fieldName} column',
        values: {
          fieldName: id
        }
      }),
      onChange: e => {
        const isChecked = e.target.checked;
        return isChecked ? onAddColumn(id) : onRemoveColumn(id);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 9
      }
    })
  }, {
    field: 'name',
    name: _i18n.i18n.translate('xpack.csp.dataTable.fieldsModalName', {
      defaultMessage: 'Name'
    }),
    sortable: true
  }];
  const error = (0, _react.useMemo)(() => {
    if (!dataView || dataView.fields.length === 0) {
      return _i18n.i18n.translate('xpack.csp.dataTable.fieldsModalError', {
        defaultMessage: 'No fields found in the data view'
      });
    }
    return '';
  }, [dataView]);
  const search = {
    onChange: onQueryChange,
    box: {
      incremental: true,
      placeholder: _i18n.i18n.translate('xpack.csp.dataTable.fieldsModalSearch', {
        defaultMessage: 'Search field name'
      })
    }
  };
  const tableHeader = (0, _react.useMemo)(() => {
    const totalFields = fields.length;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": "csp:dataTable:fieldsModal:fieldsShowing",
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.dataTable.fieldsModalFieldsShowing",
      defaultMessage: "Showing",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 190,
        columnNumber: 13
      }
    }), ' ', /*#__PURE__*/_react.default.createElement("strong", {
      "data-test-subj": "csp:dataTable:fieldsModal:fieldsCount",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 13
      }
    }, totalFields), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.dataTable.fieldsModalFieldsCount",
      defaultMessage: "{totalFields, plural, one {field} other {fields}}",
      values: {
        totalFields
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      panelPaddingSize: "none",
      anchorPosition: "downRight",
      isOpen: isPopoverOpen,
      closePopover: closePopover,
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        "data-test-subj": "viewSelectorButton",
        size: "xs",
        iconType: "arrowDown",
        iconSide: "right",
        onClick: togglePopover,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 211,
          columnNumber: 15
        }
      }, `${VIEW_LABEL}: ${isFilterSelectedEnabled ? VIEW_VALUE_SELECTED : VIEW_VALUE_ALL}`),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      "data-test-subj": "viewSelectorMenu",
      size: "s",
      items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "data-test-subj": "viewSelectorOption-all",
        key: "viewAll",
        icon: isFilterSelectedEnabled ? 'empty' : 'check',
        onClick: () => {
          onFilterSelectedChange(false);
          closePopover();
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 226,
          columnNumber: 17
        }
      }, `${VIEW_LABEL} ${VIEW_VALUE_ALL}`), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
        key: "separator",
        margin: "none",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 237,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "data-test-subj": "viewSelectorOption-selected",
        key: "viewSelected",
        icon: isFilterSelectedEnabled ? 'check' : 'empty',
        onClick: () => {
          onFilterSelectedChange(true);
          closePopover();
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 238,
          columnNumber: 17
        }
      }, `${VIEW_LABEL} ${VIEW_VALUE_SELECTED}`)],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 13
      }
    }))));
  }, [closePopover, fields.length, isFilterSelectedEnabled, isPopoverOpen, onFilterSelectedChange, togglePopover]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    tableCaption: title,
    items: fields,
    columns: tableColumns,
    search: search,
    pagination: pagination,
    sorting: defaultSorting,
    error: error,
    childrenBetween: tableHeader,
    onTableChange: onTableChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 5
    }
  });
};
exports.FieldsSelectorTable = FieldsSelectorTable;