"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldsSelectorModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _fields_selector_table = require("./fields_selector_table");
var _test_subjects = require("../../test_subjects");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/cloud_security_data_table/fields_selector/fields_selector_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const title = _i18n.i18n.translate('xpack.csp.dataTable.fieldsModalTitle', {
  defaultMessage: 'Fields'
});
const FieldsSelectorModal = ({
  closeModal,
  dataView,
  columns,
  onAddColumn,
  onRemoveColumn,
  onResetColumns
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal,
    "data-test-subj": _test_subjects.CSP_FIELDS_SELECTOR_MODAL,
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_fields_selector_table.FieldsSelectorTable, {
    title: title,
    dataView: dataView,
    columns: columns,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onResetColumns,
    "data-test-subj": _test_subjects.CSP_FIELDS_SELECTOR_RESET_BUTTON,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.dataTable.fieldsModalReset",
    defaultMessage: "Reset Fields",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: closeModal,
    fill: true,
    "data-test-subj": _test_subjects.CSP_FIELDS_SELECTOR_CLOSE_BUTTON,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.dataTable.fieldsModalClose",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }))));
};
exports.FieldsSelectorModal = FieldsSelectorModal;