"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdditionalControls = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _i18n = require("@kbn/i18n");
var _fields_selector = require("./fields_selector");
var _use_styles = require("./use_styles");
var _test_subjects = require("../test_subjects");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/cloud_security_data_table/additional_controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const GroupSelectorWrapper = ({
  children
}) => {
  const styles = (0, _use_styles.useStyles)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: styles.groupBySelector,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 5
    }
  }, children);
};
const AdditionalControls = ({
  total,
  title,
  dataView,
  columns,
  onAddColumn,
  onRemoveColumn,
  groupSelectorComponent,
  onResetColumns
}) => {
  const {
    isFieldSelectorModalVisible,
    closeFieldsSelectorModal,
    openFieldsSelectorModal
  } = (0, _fields_selector.useFieldsModal)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isFieldSelectorModalVisible && /*#__PURE__*/_react.default.createElement(_fields_selector.FieldsSelectorModal, {
    columns: columns,
    dataView: dataView,
    closeModal: closeFieldsSelectorModal,
    onAddColumn: onAddColumn,
    onRemoveColumn: onRemoveColumn,
    onResetColumns: onResetColumns,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "cspDataTableTotal",
    role: "status",
    "aria-live": "polite",
    "aria-label": _i18n.i18n.translate('xpack.csp.dataTable.totalFindings', {
      defaultMessage: 'Total findings: {total} {title}',
      values: {
        total: (0, _cloudSecurityPostureCommon.getAbbreviatedNumber)(total),
        title
      }
    }),
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, `${(0, _cloudSecurityPostureCommon.getAbbreviatedNumber)(total)} ${title}`)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "tableOfContents",
    onClick: openFieldsSelectorModal,
    size: "xs",
    color: "text",
    "data-test-subj": _test_subjects.CSP_FIELDS_SELECTOR_OPEN_BUTTON,
    "aria-label": _i18n.i18n.translate('xpack.csp.dataTable.fieldsButtonAriaLabel', {
      defaultMessage: 'Open fields selector to customize table columns'
    }),
    title: _i18n.i18n.translate('xpack.csp.dataTable.fieldsButtonTooltip', {
      defaultMessage: 'Select which fields to display in the table'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.dataTable.fieldsButton",
    defaultMessage: "Fields",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }))), groupSelectorComponent && /*#__PURE__*/_react.default.createElement(GroupSelectorWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }, groupSelectorComponent));
};
exports.AdditionalControls = AdditionalControls;